/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.util.HashMap;
import java.util.PriorityQueue;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class Timers {
    private int lastId = 0;
    private final HashMap<Integer, Timeout> timers = new HashMap();
    private final PriorityQueue<Timeout> timerQueue = new PriorityQueue();

    public void install(Scriptable scriptable3) {
        LambdaFunction lambdaFunction = new LambdaFunction(scriptable3, "setTimeout", 1, (context, scriptable, scriptable2, objectArray) -> this.setTimeout(objectArray));
        ScriptableObject.defineProperty(scriptable3, "setTimeout", lambdaFunction, 2);
        LambdaFunction lambdaFunction2 = new LambdaFunction(scriptable3, "clearTimeout", 1, (context, scriptable, scriptable2, objectArray) -> this.clearTimeout(objectArray));
        ScriptableObject.defineProperty(scriptable3, "clearTimeout", lambdaFunction2, 2);
    }

    public void runAllTimers(Context context, Scriptable scriptable) throws InterruptedException {
        boolean bl;
        do {
            context.processMicrotasks();
        } while (bl = this.executeNext(context, scriptable));
        context.processMicrotasks();
    }

    private boolean executeNext(Context context, Scriptable scriptable) throws InterruptedException {
        Timeout timeout = this.timerQueue.peek();
        if (timeout == null) {
            return false;
        }
        long l = timeout.expiration - System.currentTimeMillis();
        if (l > 0L) {
            Thread.sleep(l);
        }
        this.timerQueue.remove();
        this.timers.remove(timeout.id);
        context.enqueueMicrotask(() -> timeout.func.call(context, scriptable, scriptable, timeout.funcArgs));
        return true;
    }

    private Object setTimeout(Object[] objectArray) {
        if (objectArray.length == 0) {
            throw ScriptRuntime.typeError("Expected function parameter");
        }
        if (!(objectArray[0] instanceof Function)) {
            throw ScriptRuntime.typeError("Expected first argument to be a function");
        }
        int n = ++this.lastId;
        Timeout timeout = new Timeout();
        timeout.id = n;
        timeout.func = (Function)objectArray[0];
        int n2 = 0;
        if (objectArray.length > 1) {
            n2 = ScriptRuntime.toInt32(objectArray[1]);
        }
        timeout.expiration = System.currentTimeMillis() + (long)n2;
        if (objectArray.length > 2) {
            timeout.funcArgs = new Object[objectArray.length - 2];
            System.arraycopy(objectArray, 2, timeout.funcArgs, 0, timeout.funcArgs.length);
        }
        this.timers.put(n, timeout);
        this.timerQueue.add(timeout);
        return n;
    }

    private Object clearTimeout(Object[] objectArray) {
        if (objectArray.length == 0) {
            throw ScriptRuntime.typeError("Expected function parameter");
        }
        int n = ScriptRuntime.toInt32(objectArray[0]);
        Timeout timeout = this.timers.remove(n);
        if (timeout != null) {
            this.timerQueue.remove(timeout);
        }
        return Undefined.instance;
    }

    private static final class Timeout
    implements Comparable<Timeout> {
        int id;
        Function func;
        Object[] funcArgs = ScriptRuntime.emptyArgs;
        long expiration;

        private Timeout() {
        }

        @Override
        public int compareTo(Timeout timeout) {
            return Long.compare(this.expiration, timeout.expiration);
        }

        public boolean equals(Object object) {
            try {
                return this.expiration == ((Timeout)object).expiration;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            assert (false);
            return (int)this.expiration;
        }
    }
}

