/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.treetable.TreeTableModel;

class VariableModel
implements TreeTableModel {
    private static final String[] cNames = new String[]{" Name", " Value"};
    private static final Class<?>[] cTypes = new Class[]{TreeTableModel.class, String.class};
    private static final VariableNode[] CHILDLESS = new VariableNode[0];
    private Dim debugger;
    private VariableNode root;

    public VariableModel() {
    }

    public VariableModel(Dim dim, Object object) {
        this.debugger = dim;
        this.root = new VariableNode(object, "this");
    }

    @Override
    public Object getRoot() {
        if (this.debugger == null) {
            return null;
        }
        return this.root;
    }

    @Override
    public int getChildCount(Object object) {
        if (this.debugger == null) {
            return 0;
        }
        VariableNode variableNode = (VariableNode)object;
        return this.children(variableNode).length;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (this.debugger == null) {
            return null;
        }
        VariableNode variableNode = (VariableNode)object;
        return this.children(variableNode)[n];
    }

    @Override
    public boolean isLeaf(Object object) {
        if (this.debugger == null) {
            return true;
        }
        VariableNode variableNode = (VariableNode)object;
        return this.children(variableNode).length == 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (this.debugger == null) {
            return -1;
        }
        VariableNode variableNode = (VariableNode)object;
        VariableNode variableNode2 = (VariableNode)object2;
        VariableNode[] variableNodeArray = this.children(variableNode);
        for (int i = 0; i != variableNodeArray.length; ++i) {
            if (variableNodeArray[i] != variableNode2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return n == 0;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return cNames[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return cTypes[n];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object getValueAt(Object var1_1, int var2_2) {
        if (this.debugger == null) {
            return null;
        }
        var3_3 = (VariableNode)var1_1;
        switch (var2_2) {
            case 0: {
                return var3_3.toString();
            }
            case 1: {
                try {
                    var4_4 = this.debugger.objectToString(this.getValue(var3_3));
                }
                catch (RuntimeException var5_5) {
                    var4_4 = var5_5.getMessage();
                    if (var4_4 != null) ** GOTO lbl15
                    var4_4 = var5_5.toString();
                }
lbl15:
                // 3 sources

                var5_6 = new StringBuilder();
                var6_7 = var4_4.length();
                for (var7_8 = 0; var7_8 < var6_7; ++var7_8) {
                    var8_9 = var4_4.charAt(var7_8);
                    if (Character.isISOControl(var8_9)) {
                        var8_9 = ' ';
                    }
                    var5_6.append(var8_9);
                }
                return var5_6.toString();
            }
        }
        return null;
    }

    private VariableNode[] children(VariableNode variableNode) {
        VariableNode[] variableNodeArray;
        if (variableNode.children != null) {
            return variableNode.children;
        }
        Object object = this.getValue(variableNode);
        Object[] objectArray = this.debugger.getObjectIds(object);
        if (objectArray == null || objectArray.length == 0) {
            variableNodeArray = CHILDLESS;
        } else {
            Arrays.sort(objectArray, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    if (object instanceof String) {
                        if (object2 instanceof Integer) {
                            return -1;
                        }
                        return ((String)object).compareToIgnoreCase((String)object2);
                    }
                    if (object2 instanceof String) {
                        return 1;
                    }
                    int n = (Integer)object;
                    int n2 = (Integer)object2;
                    return n - n2;
                }
            });
            variableNodeArray = new VariableNode[objectArray.length];
            for (int i = 0; i != objectArray.length; ++i) {
                variableNodeArray[i] = new VariableNode(object, objectArray[i]);
            }
        }
        VariableNode.access$002(variableNode, variableNodeArray);
        return variableNodeArray;
    }

    public Object getValue(VariableNode variableNode) {
        try {
            return this.debugger.getObjectProperty(variableNode.object, variableNode.id);
        }
        catch (Exception exception) {
            return "undefined";
        }
    }

    private static class VariableNode {
        private Object object;
        private Object id;
        private VariableNode[] children;

        public VariableNode(Object object, Object object2) {
            this.object = object;
            this.id = object2;
        }

        public String toString() {
            return this.id instanceof String ? (String)this.id : "[" + (Integer)this.id + "]";
        }

        static /* synthetic */ VariableNode[] access$002(VariableNode variableNode, VariableNode[] variableNodeArray) {
            variableNode.children = variableNodeArray;
            return variableNodeArray;
        }
    }
}

