/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Hashtable;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.NativeCollectionIterator;
import org.mozilla.javascript.NativeMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeSet
extends IdScriptableObject {
    private static final long serialVersionUID = -8442212766987072986L;
    private static final Object SET_TAG = "Set";
    static final String ITERATOR_TAG = "Set Iterator";
    static final SymbolKey GETSIZE = new SymbolKey("[Symbol.getSize]");
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfSet = false;
    private static final int Id_constructor = 1;
    private static final int Id_add = 2;
    private static final int Id_delete = 3;
    private static final int Id_has = 4;
    private static final int Id_clear = 5;
    private static final int Id_keys = 6;
    private static final int Id_values = 6;
    private static final int Id_entries = 7;
    private static final int Id_forEach = 8;
    private static final int SymbolId_getSize = 9;
    private static final int SymbolId_toStringTag = 10;
    private static final int MAX_PROTOTYPE_ID = 10;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeSet nativeSet = new NativeSet();
        IdFunctionObject idFunctionObject = nativeSet.exportAsJSClass(10, scriptable, false);
        ScriptableObject scriptableObject = (ScriptableObject)context.newObject(scriptable);
        scriptableObject.put("enumerable", (Scriptable)scriptableObject, (Object)Boolean.FALSE);
        scriptableObject.put("configurable", (Scriptable)scriptableObject, (Object)Boolean.TRUE);
        scriptableObject.put("get", (Scriptable)scriptableObject, nativeSet.get(GETSIZE, (Scriptable)nativeSet));
        nativeSet.defineOwnProperty(context, "size", scriptableObject);
        ScriptRuntimeES6.addSymbolSpecies(context, scriptable, idFunctionObject);
        if (bl) {
            nativeSet.sealObject();
        }
    }

    @Override
    public String getClassName() {
        return "Set";
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(SET_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 == null) {
                    NativeSet nativeSet = new NativeSet();
                    nativeSet.instanceOfSet = true;
                    if (objectArray.length > 0) {
                        NativeSet.loadFromIterable(context, scriptable, nativeSet, NativeMap.key(objectArray));
                    }
                    return nativeSet;
                }
                throw ScriptRuntime.typeErrorById("msg.no.new", "Set");
            }
            case 2: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_add(NativeMap.key(objectArray));
            }
            case 3: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_delete(NativeMap.key(objectArray));
            }
            case 4: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_has(NativeMap.key(objectArray));
            }
            case 5: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_clear();
            }
            case 6: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_iterator(scriptable, NativeCollectionIterator.Type.VALUES);
            }
            case 7: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_iterator(scriptable, NativeCollectionIterator.Type.BOTH);
            }
            case 8: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_forEach(context, scriptable, NativeMap.key(objectArray), objectArray.length > 1 ? objectArray[1] : Undefined.instance);
            }
            case 9: {
                return NativeSet.realThis(scriptable2, idFunctionObject).js_getSize();
            }
        }
        throw new IllegalArgumentException("Set.prototype has no method: " + idFunctionObject.getFunctionName());
    }

    private Object js_add(Object object) {
        Object object2 = object;
        if (object2 instanceof Number && ((Number)object2).doubleValue() == ScriptRuntime.negativeZero) {
            object2 = ScriptRuntime.zeroObj;
        }
        this.entries.put(object2, object2);
        return this;
    }

    private Object js_delete(Object object) {
        return this.entries.deleteEntry(object);
    }

    private Object js_has(Object object) {
        return this.entries.has(object);
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scriptable, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scriptable, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_forEach(Context context, Scriptable scriptable, Object object, Object object2) {
        if (!(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Callable callable = (Callable)object;
        boolean bl = context.isStrictMode();
        for (Hashtable.Entry entry : this.entries) {
            Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object2, scriptable);
            if (scriptable2 == null && !bl) {
                scriptable2 = scriptable;
            }
            if (scriptable2 == null) {
                scriptable2 = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry entry2 = entry;
            callable.call(context, scriptable, scriptable2, new Object[]{entry2.value, entry2.value, this});
        }
        return Undefined.instance;
    }

    static void loadFromIterable(Context context, Scriptable scriptable, ScriptableObject scriptableObject, Object object) {
        if (object == null || Undefined.instance.equals(object)) {
            return;
        }
        Object object2 = ScriptRuntime.callIterator(object, context, scriptable);
        if (Undefined.instance.equals(object2)) {
            return;
        }
        ScriptableObject scriptableObject2 = NativeSet.ensureScriptableObject(context.newObject(scriptable, scriptableObject.getClassName()));
        Callable callable = ScriptRuntime.getPropFunctionAndThis(scriptableObject2.getPrototype(), "add", context, scriptable);
        ScriptRuntime.lastStoredScriptable(context);
        try (IteratorLikeIterable iteratorLikeIterable = new IteratorLikeIterable(context, scriptable, object2);){
            for (Object e : iteratorLikeIterable) {
                Object object3 = e == Scriptable.NOT_FOUND ? Undefined.instance : e;
                callable.call(context, scriptable, scriptableObject, new Object[]{object3});
            }
        }
    }

    private static NativeSet realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        NativeSet nativeSet = NativeSet.ensureType(scriptable, NativeSet.class, idFunctionObject);
        if (!nativeSet.instanceOfSet) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", idFunctionObject.getFunctionName());
        }
        return nativeSet;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 9: {
                this.initPrototypeMethod(SET_TAG, n, GETSIZE, "get size", 0);
                return;
            }
            case 10: {
                this.initPrototypeValue(10, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        String string2 = null;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "add";
                break;
            }
            case 3: {
                n2 = 1;
                string = "delete";
                break;
            }
            case 4: {
                n2 = 1;
                string = "has";
                break;
            }
            case 5: {
                n2 = 0;
                string = "clear";
                break;
            }
            case 7: {
                n2 = 0;
                string = "entries";
                break;
            }
            case 6: {
                n2 = 0;
                string = "values";
                break;
            }
            case 8: {
                n2 = 1;
                string = "forEach";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(SET_TAG, n, string, string2, n2);
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (GETSIZE.equals(symbol)) {
            return 9;
        }
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 6;
        }
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 10;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "add": {
                n = 2;
                break;
            }
            case "delete": {
                n = 3;
                break;
            }
            case "has": {
                n = 4;
                break;
            }
            case "clear": {
                n = 5;
                break;
            }
            case "keys": {
                n = 6;
                break;
            }
            case "values": {
                n = 6;
                break;
            }
            case "entries": {
                n = 7;
                break;
            }
            case "forEach": {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

