/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.parser.CommentRemover;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSUnknownRule;

public class UnknownRule
extends BaseCSSRule
implements CSSUnknownRule {
    private static final long serialVersionUID = 1L;
    private String cssText = "";

    UnknownRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)0, by);
    }

    UnknownRule(UnknownRule unknownRule) {
        super(unknownRule);
        this.cssText = unknownRule.cssText;
    }

    @Override
    void clear() {
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        UnknownRule unknownRule = (UnknownRule)abstractCSSRule;
        this.setPrecedingComments(abstractCSSRule.getPrecedingComments());
        this.setTrailingComments(abstractCSSRule.getTrailingComments());
        this.cssText = unknownRule.cssText;
    }

    @Override
    public String getCssText() {
        if (this.cssText.length() == 0) {
            return "";
        }
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.cssText.length());
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return CommentRemover.removeComments(this.cssText).toString().trim();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        if (this.cssText.length() != 0) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)this.cssText);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    public void setRuleCssText(String string) {
        if (string == null) {
            throw new NullPointerException("Null rule text.");
        }
        this.cssText = string;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.cssText.hashCode();
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnknownRule unknownRule = (UnknownRule)object;
        return this.cssText.equals(unknownRule.cssText);
    }

    @Override
    public UnknownRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        return new UnknownRule(this);
    }
}

