/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractElementLiveList;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.NDTNode;
import org.w3c.dom.Node;

class TagnameElementListNS
extends AbstractElementLiveList {
    private static final long serialVersionUID = 1L;
    private final String localName;
    private final String namespaceURI;
    private final boolean matchAll;
    private final boolean matchAllNS;

    TagnameElementListNS(NDTNode nDTNode, String string, String string2, boolean bl, boolean bl2) {
        super(nDTNode);
        this.localName = string;
        this.namespaceURI = string2;
        this.matchAll = bl;
        this.matchAllNS = bl2;
    }

    @Override
    boolean matches(DOMElement dOMElement, Node node) {
        return dOMElement == node && (this.matchAll || dOMElement.getLocalName().equals(this.localName)) && this.isSameNamespace(dOMElement);
    }

    @Override
    boolean matches(DOMElement dOMElement) {
        return (this.matchAll || dOMElement.getLocalName().equals(this.localName)) && this.isSameNamespace(dOMElement);
    }

    private boolean isSameNamespace(DOMElement dOMElement) {
        if (this.matchAllNS) {
            return true;
        }
        String string = dOMElement.getNamespaceURI();
        if (string == null) {
            return this.namespaceURI == null || dOMElement.isDefaultNamespace(this.namespaceURI);
        }
        return string.equals(this.namespaceURI) || this.namespaceURI == null && dOMElement.isDefaultNamespace(string);
    }
}

