/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconFactory;

public class ZoomedIcon
extends UIIcon {
    private static final Map<UIIcon, Map<Float, ImageIcon>> zoomedBitmapIcons = new HashMap<UIIcon, Map<Float, ImageIcon>>();
    private final UIIcon uiIcon;
    private final float zoom;
    private ImageIcon zoomedIcon;

    public ZoomedIcon(UIIcon uiIcon, float zoom) {
        super(uiIcon.getName(), uiIcon.getFile(), uiIcon.getDescriptionTranslationKey(), uiIcon.getShortcutKey(), uiIcon.getOrder());
        this.uiIcon = uiIcon;
        this.zoom = zoom;
    }

    @Override
    public Icon getIcon() {
        if (this.uiIcon.getUrl().getPath().endsWith(".svg")) {
            Icon icon = this.uiIcon.getIcon();
            int ownHeight = icon.getIconHeight();
            Quantity iconHeight = new Quantity((double)ownHeight, (Enum)LengthUnit.px);
            return IconFactory.getInstance().getIcon(this, (Quantity<LengthUnit>)iconHeight.zoomBy((double)this.zoom));
        }
        return this.getZoomedBitmapIcon();
    }

    @Override
    public Icon getIcon(Quantity<LengthUnit> iconHeight) {
        if (this.uiIcon.getUrl().getPath().endsWith(".svg")) {
            return IconFactory.getInstance().getIcon(this, (Quantity<LengthUnit>)iconHeight.zoomBy((double)this.zoom));
        }
        return this.getZoomedBitmapIcon();
    }

    private Icon getZoomedBitmapIcon() {
        if (this.zoomedIcon == null) {
            Map<Float, ImageIcon> icons = zoomedBitmapIcons.get(this.uiIcon);
            if (icons == null) {
                icons = new HashMap<Float, ImageIcon>();
                zoomedBitmapIcons.put(this.uiIcon, icons);
            }
            this.zoomedIcon = icons.get(Float.valueOf(this.zoom));
            if (this.zoomedIcon != null) {
                return this.zoomedIcon;
            }
            Icon icon = this.uiIcon.getIcon();
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            Image scaledImage = image.getScaledInstance((int)((float)width * this.zoom), (int)((float)height * this.zoom), 4);
            this.zoomedIcon = new ImageIcon(scaledImage);
            icons.put(Float.valueOf(this.zoom), this.zoomedIcon);
            g.dispose();
        }
        return this.zoomedIcon;
    }

    @Override
    public String getPath() {
        return this.uiIcon.getPath();
    }

    @Override
    public URL getUrl() {
        return this.uiIcon.getUrl();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.zoom == ((ZoomedIcon)obj).zoom;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Float.valueOf(this.zoom).hashCode();
    }
}

