/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

class ImportLinkedBranchWithoutRootAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportLinkedBranchWithoutRootAction() {
        super("ImportLinkedBranchWithoutRootAction");
    }

    public void actionPerformed(ActionEvent e) {
        MapModel map = Controller.getCurrentController().getMap();
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel selected = modeController.getMapController().getSelectedNode();
        if (selected == null || NodeLinks.getLink((NodeModel)selected) == null) {
            JOptionPane.showMessageDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.getText((String)"import_linked_branch_no_link"));
            return;
        }
        try {
            URI uri = NodeLinks.getLink((NodeModel)selected).getUri();
            URL url = map.getURL();
            File file = uri.isAbsolute() && !uri.isOpaque() ? new File(uri) : new File(new URL(url, uri.getPath()).getFile());
            NodeModel node = ((MFileManager)UrlManager.getController()).loadTree(map, file);
            map.setURL(url);
            NodeModel.Side side = MapController.suggestNewChildSide((NodeModel)selected, (NodeModel.Side)NodeModel.Side.DEFAULT);
            for (NodeModel child : node.getChildren()) {
                child.setParent(null);
                child.setSide(side);
                ((MMapController)modeController.getMapController()).insertNode(child, selected);
            }
            ((MLinkController)LinkController.getController()).setLink(selected, (URI)null, 0);
        }
        catch (Exception ex) {
            UrlManager.getController().handleLoadingException(ex);
        }
    }
}

