/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.freeplane.core.ui.components.FocusRequestor;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.bookmarks.mindmapmode.MapBookmarks;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmarkDescriptor;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;

class BookmarkEditor {
    BookmarkEditor() {
    }

    public BookmarkSelectionResult editBookmarksForSelection(IMapSelection selection, MapBookmarks bookmarks, String suggestedBookmarkName) {
        BookmarkDialogComponents dialogComponents;
        boolean isSingleSelection = selection.size() == 1;
        boolean hasAnyBookmark = this.hasAnyExistingBookmarks(selection, bookmarks);
        if (isSingleSelection) {
            NodeModel selectedNode = selection.getSelected();
            NodeBookmark existingBookmark = bookmarks.getBookmark(selectedNode.getID());
            dialogComponents = this.createSingleNodeDialogComponents(selectedNode, existingBookmark, suggestedBookmarkName);
        } else {
            dialogComponents = this.createMultipleNodesDialogComponents(hasAnyBookmark);
        }
        Object[] options = this.createDialogOptions(hasAnyBookmark);
        int result = this.showBookmarkDialog(dialogComponents, options, "BookmarkNodeAction.text");
        return this.createBookmarkSelectionResult(result, dialogComponents, isSingleSelection, hasAnyBookmark);
    }

    public NodeBookmarkDescriptor showAddNewNodeDialog() {
        BookmarkDialogComponents dialogComponents = this.createNewNodeDialogComponents();
        Object[] options = this.createSimpleDialogOptions();
        int result = this.showBookmarkDialog(dialogComponents, options, "menu_newNode");
        boolean OK_OPTION = false;
        if (result != 0) {
            return null;
        }
        String content = dialogComponents.getNameInput().getText().trim();
        if (content.isEmpty()) {
            return null;
        }
        return new NodeBookmarkDescriptor(content, dialogComponents.getOpensAsRootCheckBox().isSelected());
    }

    private BookmarkDialogComponents createSingleNodeDialogComponents(NodeModel node, NodeBookmark existingBookmark, String suggestedBookmarkName) {
        boolean currentOpensAsRoot = existingBookmark != null ? existingBookmark.getDescriptor().opensAsRoot() : false;
        JCheckBox opensAsRootCheckBox = TranslatedElementFactory.createCheckBox((String)"bookmark.opens_as_root");
        opensAsRootCheckBox.setSelected(currentOpensAsRoot);
        if (node.isRoot()) {
            opensAsRootCheckBox.setEnabled(false);
        }
        String currentName = existingBookmark != null ? existingBookmark.getDescriptor().getName() : suggestedBookmarkName;
        return this.createNameAndRootComponents(currentName, opensAsRootCheckBox);
    }

    private BookmarkDialogComponents createMultipleNodesDialogComponents(boolean hasAnyBookmark) {
        JCheckBox opensAsRootCheckBox = TranslatedElementFactory.createCheckBox((String)"bookmark.opens_as_root");
        opensAsRootCheckBox.setSelected(false);
        if (hasAnyBookmark) {
            JCheckBox overwriteNamesCheckBox = TranslatedElementFactory.createCheckBox((String)"bookmark.overwrite_names");
            overwriteNamesCheckBox.setSelected(false);
            Box components = Box.createVerticalBox();
            components.add(overwriteNamesCheckBox);
            components.add(opensAsRootCheckBox);
            return new BookmarkDialogComponents(components, null, opensAsRootCheckBox, overwriteNamesCheckBox);
        }
        return new BookmarkDialogComponents(opensAsRootCheckBox, null, opensAsRootCheckBox, null);
    }

    private BookmarkDialogComponents createNewNodeDialogComponents() {
        JCheckBox opensAsRootCheckBox = TranslatedElementFactory.createCheckBox((String)"bookmark.opens_as_root");
        opensAsRootCheckBox.setSelected(true);
        return this.createNameAndRootComponents("", opensAsRootCheckBox, "bookmark.nodeContent");
    }

    private int showBookmarkDialog(BookmarkDialogComponents dialogComponents, Object[] options, String titleKey) {
        String title = TextUtils.getText((String)titleKey);
        return JOptionPane.showOptionDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), dialogComponents.getContainer(), title, 1, -1, null, options, options[0]);
    }

    private BookmarkSelectionResult createBookmarkSelectionResult(int result, BookmarkDialogComponents dialogComponents, boolean isSingleSelection, boolean hasAnyBookmark) {
        int DELETE_OPTION;
        boolean OK_OPTION = false;
        int n = DELETE_OPTION = hasAnyBookmark ? 1 : -1;
        if (result == 0) {
            return isSingleSelection ? this.createSingleSelectionResult(dialogComponents) : this.createMultipleSelectionResult(dialogComponents);
        }
        if (result == DELETE_OPTION) {
            return new BookmarkSelectionResult(BookmarkSelectionResult.Action.DELETE_BOOKMARKS);
        }
        return new BookmarkSelectionResult(BookmarkSelectionResult.Action.CANCEL);
    }

    private BookmarkSelectionResult createSingleSelectionResult(BookmarkDialogComponents dialogComponents) {
        String bookmarkName = dialogComponents.getNameInput().getText().trim();
        if (bookmarkName.isEmpty()) {
            return new BookmarkSelectionResult(BookmarkSelectionResult.Action.CANCEL);
        }
        boolean opensAsRoot = dialogComponents.getOpensAsRootCheckBox().isSelected();
        return new BookmarkSelectionResult(BookmarkSelectionResult.Action.ADD_BOOKMARKS, bookmarkName, opensAsRoot, false);
    }

    private BookmarkSelectionResult createMultipleSelectionResult(BookmarkDialogComponents dialogComponents) {
        boolean opensAsRoot = dialogComponents.getOpensAsRootCheckBox().isSelected();
        JCheckBox overwriteNamesCheckBox = dialogComponents.getOverwriteNamesCheckBox();
        boolean shouldOverwriteNames = overwriteNamesCheckBox != null && overwriteNamesCheckBox.isSelected();
        return new BookmarkSelectionResult(BookmarkSelectionResult.Action.ADD_BOOKMARKS, null, opensAsRoot, shouldOverwriteNames);
    }

    private BookmarkDialogComponents createNameAndRootComponents(String nameText, JCheckBox opensAsRootCheckBox) {
        JTextField nameInput = this.createNameInput(nameText, "bookmark.name");
        Box components = Box.createVerticalBox();
        components.add(nameInput);
        components.add(opensAsRootCheckBox);
        return new BookmarkDialogComponents(components, nameInput, opensAsRootCheckBox);
    }

    private BookmarkDialogComponents createNameAndRootComponents(String nameText, JCheckBox opensAsRootCheckBox, String textKey) {
        JTextField nameInput = this.createNameInput(nameText, textKey);
        Box components = Box.createVerticalBox();
        components.add(nameInput);
        components.add(opensAsRootCheckBox);
        return new BookmarkDialogComponents(components, nameInput, opensAsRootCheckBox);
    }

    private JTextField createNameInput(String initialText, String textKey) {
        JTextField nameInput = new JTextField(initialText, 40);
        FocusRequestor.requestFocus((Component)nameInput);
        TranslatedElementFactory.createTitledBorder((JComponent)nameInput, (String)textKey);
        return nameInput;
    }

    private Object[] createDialogOptions(boolean hasAnyBookmark) {
        if (hasAnyBookmark) {
            return new Object[]{TextUtils.getText((String)"icon_button_ok"), TextUtils.getText((String)"delete"), TextUtils.getText((String)"cancel")};
        }
        return this.createSimpleDialogOptions();
    }

    private Object[] createSimpleDialogOptions() {
        return new Object[]{TextUtils.getText((String)"icon_button_ok"), TextUtils.getText((String)"cancel")};
    }

    private boolean hasAnyExistingBookmarks(IMapSelection selection, MapBookmarks bookmarks) {
        return selection.getOrderedSelection().stream().anyMatch(node -> bookmarks.getBookmark(node.getID()) != null);
    }

    public static class BookmarkDialogComponents {
        private final JComponent container;
        private final JTextField nameInput;
        private final JCheckBox opensAsRootCheckBox;
        private final JCheckBox overwriteNamesCheckBox;

        public BookmarkDialogComponents(JComponent container, JTextField nameInput, JCheckBox opensAsRootCheckBox) {
            this(container, nameInput, opensAsRootCheckBox, null);
        }

        public BookmarkDialogComponents(JComponent container, JTextField nameInput, JCheckBox opensAsRootCheckBox, JCheckBox overwriteNamesCheckBox) {
            this.container = container;
            this.nameInput = nameInput;
            this.opensAsRootCheckBox = opensAsRootCheckBox;
            this.overwriteNamesCheckBox = overwriteNamesCheckBox;
        }

        public JComponent getContainer() {
            return this.container;
        }

        public JTextField getNameInput() {
            return this.nameInput;
        }

        public JCheckBox getOpensAsRootCheckBox() {
            return this.opensAsRootCheckBox;
        }

        public JCheckBox getOverwriteNamesCheckBox() {
            return this.overwriteNamesCheckBox;
        }
    }

    public static class BookmarkSelectionResult {
        private final Action action;
        private final String bookmarkName;
        private final boolean opensAsRoot;
        private final boolean overwriteNames;

        public BookmarkSelectionResult(Action action) {
            this(action, null, false, false);
        }

        public BookmarkSelectionResult(Action action, String bookmarkName, boolean opensAsRoot, boolean overwriteNames) {
            this.action = action;
            this.bookmarkName = bookmarkName;
            this.opensAsRoot = opensAsRoot;
            this.overwriteNames = overwriteNames;
        }

        public Action getAction() {
            return this.action;
        }

        public String getBookmarkName() {
            return this.bookmarkName;
        }

        public boolean opensAsRoot() {
            return this.opensAsRoot;
        }

        public boolean shouldOverwriteNames() {
            return this.overwriteNames;
        }

        public static enum Action {
            ADD_BOOKMARKS,
            DELETE_BOOKMARKS,
            CANCEL;

        }
    }
}

