/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml.rules;

import com.tngtech.archunit.library.plantuml.rules.Alias;
import com.tngtech.archunit.library.plantuml.rules.ComponentName;
import com.tngtech.archunit.library.plantuml.rules.IllegalDiagramException;
import com.tngtech.archunit.library.plantuml.rules.ParsedDependency;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponent;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponents;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlDiagram;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlParseException;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlPatterns;
import com.tngtech.archunit.library.plantuml.rules.Stereotype;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlantUmlParser {
    private static final Logger log = LoggerFactory.getLogger(PlantUmlParser.class);
    private final PlantUmlPatterns plantUmlPatterns = new PlantUmlPatterns();

    PlantUmlParser() {
    }

    PlantUmlDiagram parse(URL url) {
        Preconditions.checkNotNull(url, "URL must not be null");
        return this.createDiagram(this.readLines(url));
    }

    private PlantUmlDiagram createDiagram(List<String> rawDiagramLines) {
        List<String> diagramLines = this.filterOutComments(rawDiagramLines);
        Set<PlantUmlComponent> components = this.parseComponents(diagramLines);
        PlantUmlComponents plantUmlComponents = new PlantUmlComponents(components);
        ImmutableList<ParsedDependency> dependencies = this.parseDependencies(plantUmlComponents, diagramLines);
        return new PlantUmlDiagram.Builder(plantUmlComponents).withDependencies(dependencies).build();
    }

    private List<String> filterOutComments(List<String> lines) {
        Pattern commentPattern = Pattern.compile("^\\s*'");
        return lines.stream().filter(line -> !commentPattern.matcher((CharSequence)line).find()).collect(Collectors.toList());
    }

    private List<String> readLines(URL url) {
        List<String> list;
        InputStreamReader in = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
        try {
            list = CharStreams.readLines(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PlantUmlParseException("Could not parse diagram from " + url, e);
            }
        }
        in.close();
        return list;
    }

    private Set<PlantUmlComponent> parseComponents(List<String> plantUmlDiagramLines) {
        return this.plantUmlPatterns.filterComponents(plantUmlDiagramLines).map(this::createNewComponent).collect(Collectors.toSet());
    }

    private ImmutableList<ParsedDependency> parseDependencies(PlantUmlComponents plantUmlComponents, List<String> plantUmlDiagramLines) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (PlantUmlPatterns.PlantUmlDependencyMatcher matcher : this.plantUmlPatterns.matchDependencies(plantUmlDiagramLines)) {
            Optional<PlantUmlComponent> origin = this.tryFindComponentMatching(plantUmlComponents, matcher.matchOrigin());
            Optional<PlantUmlComponent> target = this.tryFindComponentMatching(plantUmlComponents, matcher.matchTarget());
            if (origin.isPresent() && target.isPresent()) {
                result.add(new ParsedDependency(origin.get().getIdentifier(), target.get().getIdentifier()));
                continue;
            }
            log.trace("Ignoring dependency from {} to {}, because origin or target couldn't be parsed", (Object)matcher.matchOrigin(), (Object)matcher.matchTarget());
        }
        return result.build();
    }

    private PlantUmlComponent createNewComponent(String input) {
        PlantUmlPatterns.PlantUmlComponentMatcher matcher = this.plantUmlPatterns.matchComponent(input);
        ComponentName componentName = new ComponentName(matcher.matchComponentName());
        ImmutableSet<Stereotype> immutableStereotypes = this.identifyStereotypes(matcher, componentName);
        Optional<Alias> alias = matcher.matchAlias().map(Alias::new);
        return new PlantUmlComponent.Builder().withComponentName(componentName).withStereotypes(immutableStereotypes).withAlias(alias).build();
    }

    private ImmutableSet<Stereotype> identifyStereotypes(PlantUmlPatterns.PlantUmlComponentMatcher matcher, ComponentName componentName) {
        ImmutableSet.Builder stereotypes = ImmutableSet.builder();
        for (String stereotype : matcher.matchStereoTypes()) {
            stereotypes.add(new Stereotype(stereotype));
        }
        ImmutableCollection result = stereotypes.build();
        if (result.isEmpty()) {
            throw new IllegalDiagramException(String.format("Components must include at least one stereotype specifying the package identifier(<<..>>), but component '%s' does not", componentName.asString()), new Object[0]);
        }
        return result;
    }

    private Optional<PlantUmlComponent> tryFindComponentMatching(PlantUmlComponents plantUmlComponents, String originOrTargetString) {
        originOrTargetString = originOrTargetString.trim().replaceAll("^\\[", "").replaceAll("]$", "");
        return plantUmlComponents.tryFindComponentWith(originOrTargetString);
    }
}

