/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import org.sunflow.image.SpectralCurve;

public class IrregularSpectralCurve
extends SpectralCurve {
    private final float[] wavelengths;
    private final float[] amplitudes;

    public IrregularSpectralCurve(float[] fArray, float[] fArray2) {
        this.wavelengths = fArray;
        this.amplitudes = fArray2;
        if (fArray.length != fArray2.length) {
            throw new RuntimeException(String.format("Error creating irregular spectral curve: %d wavelengths and %d amplitudes", fArray.length, fArray2.length));
        }
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i - 1] >= fArray[i])) continue;
            throw new RuntimeException(String.format("Error creating irregular spectral curve: values are not sorted - error at index %d", i));
        }
    }

    public float sample(float f) {
        if (this.wavelengths.length == 0) {
            return 0.0f;
        }
        if (this.wavelengths.length == 1 || f <= this.wavelengths[0]) {
            return this.amplitudes[0];
        }
        if (f >= this.wavelengths[this.wavelengths.length - 1]) {
            return this.amplitudes[this.wavelengths.length - 1];
        }
        for (int i = 1; i < this.wavelengths.length; ++i) {
            if (!(f < this.wavelengths[i])) continue;
            float f2 = (f - this.wavelengths[i - 1]) / (this.wavelengths[i] - this.wavelengths[i - 1]);
            return (1.0f - f2) * this.amplitudes[i - 1] + f2 * this.amplitudes[i];
        }
        return this.amplitudes[this.wavelengths.length - 1];
    }
}

