The Meterpreter payload supports a number of [[transport|Meterpreter Transport Control]], including ``reverse_http`` and ``reverse_https``. This document describes how these transports work.

### The Initial URL

During the generation process for a new ``reverse_http`` or ``reverse_https`` payload, an initial connect-back URL will be created. This URL will be either "short" or "long" and the 8-bit checksum of this URL will be set to one of the ``INIT_*`` constants defined in the [UriChecksum](https://github.com/rapid7/metasploit-framework/blob/master/lib/rex/payloads/meterpreter/uri_checksum.rb) mixin. The URL will be generated using the [base64url](https://tools.ietf.org/html/rfc4648#section-5) character set. The "short" URL will always be 5 bytes in length while the "long" URL will be between 30 and 128 bytes in length. Which variant is used is determined by the space constraints of the exploit that generates the payload. The "long" URL can also include an embedded Payload UUID.

### The Connection URL

The HTTP handler within Metasploit will receive the request for the initial URL, determine which ```INIT_*``` checksum it correlates to, extract any embedded [[Payload UUID]], and then respond with either the second stage for staged payloads or a new URL for stageless payloads. The new URL is generated by the handler, will embed any Payload UUID that was included in the original request, and will hash to the value defined by the ```URI_CHECKSUM_CONN``` constant. Note that characters other than the base64url character set are ignored during calculation of the checksum.

The connect URL must be unique between sessions in order for the sessions to function properly.

### TLS Certificate Pinning

The Meterpreter HTTPS transport supports certificate pinning. This applies to the stageless payloads as well as Meterpreter payloads loaded with the ```reverse_winhttps``` stagers. At this time, some of the non-Windows stagers also support certificate pinning, but this is still a work in progress. Certificate pinning is enabled by setting the ```StagerVerifySSLCert``` option to ```true``` and by extracting a SHA1 hash of the certificate specified in the ```HandlerSSLCert``` option. The SHA1 hash of the certificate will be verified during the staging process, and also in the handler, if these options are specified in the listener. This feature requires the pre-generation of a unified SSL/TLS certificate in PEM format, with the private key followed by one or more certificates in the chain. If an incoming session connects through a man-in-the-middle proxy that presents a different certificate, the first connection will connect back, but then immediately terminate. The handler will detect a non-responsive connection and close the session automatically.

The command below generates a custom unified PEM TLS certificate that works with the ```HandlerSSLCert``` option:

```
$ openssl req -new -newkey rsa:4096 -days 365 -nodes -x509 \
    -subj "/C=US/ST=Texas/L=Austin/O=Development/CN=www.example.com" \
    -keyout www.example.com.key \
    -out www.example.com.crt && \
cat www.example.com.key  www.example.com.crt > www.example.com.pem && \
rm -f www.example.com.key  www.example.com.crt
```

### The Application Protocol

Once the Meterpreter connect URL is requested, the actual dispatch loop starts to run. The Meterpreter payload will make repeated requests with a HTTP body consistent of "RECV". Any queued commands will be returned to the payload, which will process them individually, and return the results in a following request. If no commands were returned as a result of a "RECV" request, the payload will double the interval until the next request, with a maximum that is generally about 10 seconds.

Additional details about the configuration of the HTTP transport can be found on the [[transport control|Meterpreter Transport Control]] wiki page.