#pragma once

#include "esphome/core/component.h"
#include "esphome/core/automation.h"
#include "esphome/core/template_lambda.h"
#include "esphome/components/switch/switch.h"

namespace esphome {
namespace template_ {

class TemplateSwitch final : public switch_::Switch, public Component {
 public:
  TemplateSwitch();

  void setup() override;
  void dump_config() override;

  template<typename F> void set_state_lambda(F &&f) { this->f_.set(std::forward<F>(f)); }
  Trigger<> *get_turn_on_trigger() const;
  Trigger<> *get_turn_off_trigger() const;
  void set_optimistic(bool optimistic);
  void set_assumed_state(bool assumed_state);
  void loop() override;

  float get_setup_priority() const override;

 protected:
  bool assumed_state() override;

  void write_state(bool state) override;

  TemplateLambda<bool> f_;
  bool optimistic_{false};
  bool assumed_state_{false};
  Trigger<> *turn_on_trigger_;
  Trigger<> *turn_off_trigger_;
  Trigger<> *prev_trigger_{nullptr};
};

}  // namespace template_
}  // namespace esphome
