import { CancellationToken, CodeAction, CodeActionContext, Range, WorkspaceEdit } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { LSConfigManager } from '../../../ls-config';
import { CodeActionsProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
import { CompletionsProviderImpl } from './CompletionProvider';
/**
 * TODO change this to protocol constant if it's part of the protocol
 */
export declare const SORT_IMPORT_CODE_ACTION_KIND = "source.sortImports";
export declare const ADD_MISSING_IMPORTS_CODE_ACTION_KIND = "source.addMissingImports";
export declare const REMOVE_UNUSED_IMPORTS_CODE_ACTION_KIND = "source.removeUnusedImports";
export declare class CodeActionsProviderImpl implements CodeActionsProvider {
    private readonly lsAndTsDocResolver;
    private readonly completionProvider;
    private readonly configManager;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, completionProvider: CompletionsProviderImpl, configManager: LSConfigManager);
    getCodeActions(document: Document, range: Range, context: CodeActionContext, cancellationToken?: CancellationToken): Promise<CodeAction[]>;
    resolveCodeAction(document: Document, codeAction: CodeAction, cancellationToken?: CancellationToken | undefined): Promise<CodeAction>;
    /**
     * Do not use this in regular code action
     * This'll cause TypeScript to rebuild and invalidate caches every time. It'll be slow
     */
    private createVirtualDocumentForCombinedImportCodeFix;
    /**
     * Remove component default import if there is a named import with the same name
     * Usually happens with reexport or inheritance of component library
     */
    private removeDuplicatedComponentImport;
    private fixCombinedImportQuickFix;
    private toImportMemberRegex;
    private isQuickFixAllResolveInfo;
    private organizeImports;
    private fixIndentationOfImports;
    private checkRemoveImportCodeActionRange;
    private checkIndentLeftover;
    private applyQuickfix;
    private convertAndFixCodeFixAction;
    private findDiagnosticForImportFix;
    private findDiagnosticForQuickFix;
    private getFixAllActions;
    /**
     * import quick fix requires the symbol name to be the same as where it's defined.
     * But we have suffix on component default export to prevent conflict with
     * a local variable. So we use auto-import completion as a workaround here.
     */
    private getComponentImportQuickFix;
    private isComponentStartTag;
    private numberOfDirectorySeparators;
    private getSvelteQuickFixes;
    private findIdentifierForDiagnostic;
    private getSvelteStoreQuickFixes;
    private getAddLangTSCodeAction;
    private hasLangTsScriptTag;
    private getApplicableRefactors;
    private applicableRefactorsToCodeActions;
    executeCommand(document: Document, command: string, args?: any[]): Promise<WorkspaceEdit | null>;
    /**
     * Some refactorings place the new code at the end of svelte2tsx' render function,
     *  which is unmapped. In this case, add it to the end of the script tag ourselves.
     */
    private checkEndOfFileCodeInsert;
    private checkTsNoCheckCodeInsert;
    private checkDisableJsDiagnosticsCodeInsert;
    /**
     * svelte2tsx removes export in instance script
     */
    private fixPropsCodeActionRange;
    private checkAddJsDocCodeActionRange;
    private getLSAndTSDoc;
    private addMissingImports;
}
