/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.builders;

import com.shatteredpixel.shatteredpixeldungeon.levels.builders.Builder;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.watabou.utils.Random;
import com.watabou.utils.SparseArray;
import java.util.ArrayList;

public class GridBuilder
extends Builder {
    public static int ROOM_SIZE = 9;
    protected float extraConnectionChance = 0.3f;

    @Override
    public ArrayList<Room> build(ArrayList<Room> rooms) {
        for (Room r : rooms) {
            r.setEmpty();
        }
        Room entrance = null;
        Room exit = null;
        for (Room r : rooms) {
            if (r.isEntrance()) {
                entrance = r;
                continue;
            }
            if (!r.isExit()) continue;
            exit = r;
        }
        if (!entrance.forceSize(ROOM_SIZE, ROOM_SIZE)) {
            throw new RuntimeException("rigid room sizes for now!");
        }
        entrance.setPos(0, 0);
        ArrayList<Room> toPlace = new ArrayList<Room>(rooms);
        toPlace.remove(entrance);
        if (exit != null) {
            toPlace.remove(exit);
            toPlace.add(exit);
        }
        ArrayList<Room> placed = new ArrayList<Room>();
        placed.add(entrance);
        SparseArray<Room> gridCells = new SparseArray<Room>();
        gridCells.put(100100, entrance);
        for (Room r : toPlace) {
            int cellWidth = 1;
            int cellHeight = 1;
            if (!r.forceSize(ROOM_SIZE, ROOM_SIZE)) {
                if (!r.forceSize(2 * ROOM_SIZE - 1, 2 * ROOM_SIZE - 1)) {
                    throw new RuntimeException("rigid room sizes for now!");
                }
                cellHeight = 2;
                cellWidth = 2;
            }
            do {
                int j;
                int i;
                r.neigbours.clear();
                int[] keys = gridCells.keyArray();
                int nIdx = keys[Random.Int(keys.length)];
                Room n = gridCells.get(nIdx, null);
                int rIdx = nIdx;
                switch (Random.Int(10)) {
                    case 0: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ++rIdx;
                        break;
                    }
                    case 1: 
                    case 7: 
                    case 8: 
                    case 9: {
                        rIdx += 1000;
                        break;
                    }
                    case 2: {
                        --rIdx;
                        break;
                    }
                    case 3: {
                        rIdx -= 1000;
                    }
                }
                int x = rIdx % 1000 - 100;
                int y = rIdx / 1000 - 100;
                r.setPos(x * (ROOM_SIZE - 1), y * (ROOM_SIZE - 1));
                boolean valid = true;
                for (i = 0; i < cellWidth; ++i) {
                    for (j = 0; j < cellHeight; ++j) {
                        if (!gridCells.containsKey(rIdx + i + j * 1000)) continue;
                        valid = false;
                    }
                }
                if (!valid || !r.connect(n)) continue;
                placed.add(r);
                for (i = 0; i < cellWidth; ++i) {
                    for (j = 0; j < cellHeight; ++j) {
                        gridCells.put(rIdx + i + j * 1000, r);
                    }
                }
            } while (!placed.contains(r));
        }
        GridBuilder.findNeighbours(rooms);
        for (Room r : rooms) {
            for (Room n : r.neigbours) {
                if (n.connected.containsKey(r) || !(Random.Float() < this.extraConnectionChance)) continue;
                r.connect(n);
            }
        }
        return rooms;
    }
}

