/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import org.firebirdsql.gds.impl.GDSServerVersion;

enum ServerVersionInformation {
    VERSION_1_0(1, 0){

        @Override
        public byte[] getStatementInfoRequestItems() {
            return (byte[])Constants.V1_0_STATEMENT_INFO.clone();
        }

        @Override
        public byte[] getParameterDescriptionInfoRequestItems() {
            return (byte[])Constants.V_1_0_PARAMETER_INFO.clone();
        }
    }
    ,
    VERSION_2_0(2, 0){

        @Override
        public byte[] getStatementInfoRequestItems() {
            return (byte[])Constants.V_2_0_STATEMENT_INFO.clone();
        }

        @Override
        public byte[] getParameterDescriptionInfoRequestItems() {
            return (byte[])Constants.V_2_0_PARAMETER_INFO.clone();
        }
    };

    private final int majorVersion;
    private final int minorVersion;

    private ServerVersionInformation(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public abstract byte[] getStatementInfoRequestItems();

    public abstract byte[] getParameterDescriptionInfoRequestItems();

    public byte[] getBlobInfoRequestItems() {
        return (byte[])Constants.V_1_0_BLOB_INFO.clone();
    }

    private boolean isEqualOrBelow(int majorVersion, int minorVersion) {
        return this.majorVersion < majorVersion || this.majorVersion == majorVersion && this.minorVersion <= minorVersion;
    }

    public static ServerVersionInformation getForVersion(int majorVersion, int minorVersion) {
        ServerVersionInformation highest = VERSION_1_0;
        for (ServerVersionInformation strategy : ServerVersionInformation.values()) {
            if (!strategy.isEqualOrBelow(majorVersion, minorVersion)) break;
            highest = strategy;
        }
        return highest;
    }

    public static ServerVersionInformation getForVersion(GDSServerVersion serverVersion) {
        return ServerVersionInformation.getForVersion(serverVersion.getMajorVersion(), serverVersion.getMinorVersion());
    }

    private static final class Constants {
        static final byte[] V1_0_STATEMENT_INFO = new byte[]{21, 4, 7, 9, 11, 12, 13, 14, 16, 19, 17, 18, 8, 5, 7, 9, 11, 12, 13, 14, 8};
        static final byte[] V_1_0_PARAMETER_INFO = new byte[]{7, 9, 11, 12, 13, 14, 16, 19, 17, 18, 8};
        static final byte[] V_1_0_BLOB_INFO = new byte[]{4, 5, 6, 7, 1};
        static final byte[] V_2_0_STATEMENT_INFO = new byte[]{21, 4, 7, 9, 11, 12, 13, 14, 16, 19, 17, 25, 18, 8, 5, 7, 9, 11, 12, 13, 14, 8};
        static final byte[] V_2_0_PARAMETER_INFO = new byte[]{7, 9, 11, 12, 13, 14, 16, 19, 17, 25, 18, 8};

        private Constants() {
        }
    }
}

