/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.Arrays;

@ExportLibrary(value=InteropLibrary.class)
final class NativeObjectReferenceArrayWrapper
implements TruffleObject {
    private long[] data = new long[1024];
    private int length;

    NativeObjectReferenceArrayWrapper() {
    }

    long[] getArray() {
        return this.data;
    }

    void reset() {
        this.length = 0;
    }

    void add(long pointer) {
        if (this.length >= this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        this.data[this.length++] = pointer;
    }

    boolean isEmpty() {
        return this.length == 0;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long i) {
        return i < (long)this.length;
    }

    @ExportMessage
    Object readArrayElement(long i) {
        return this.data[(int)i];
    }
}

