/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes.memory;

import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class Pointer
implements TruffleObject {
    public static final Pointer NULL = new Pointer(new NullStorage(), 0);
    final MemoryBlock memory;
    final int offset;

    private Pointer(Storage storage, int offset) {
        this(new MemoryBlock(storage), offset);
    }

    private Pointer(MemoryBlock memory, int offset) {
        this.memory = memory;
        this.offset = offset;
    }

    @ExportMessage
    public boolean isNull() {
        return this == NULL;
    }

    public static Pointer allocate(FFIType type, int size) {
        return new Pointer(Pointer.createStorageInternal(type, size, null), 0);
    }

    public static Pointer bytes(byte[] bytes) {
        return Pointer.bytes(bytes, 0);
    }

    public static Pointer bytes(byte[] bytes, int offset) {
        return new Pointer(new ByteArrayStorage(bytes), offset);
    }

    public static Pointer nativeMemory(long nativePointer) {
        if (nativePointer == 0L) {
            return NULL;
        }
        return new Pointer(new LongPointerStorage(nativePointer), 0);
    }

    public static Pointer nativeMemory(Object nativePointer) {
        if (nativePointer instanceof Long) {
            Long value = (Long)nativePointer;
            return Pointer.nativeMemory(value);
        }
        return new Pointer(new ObjectPointerStorage(nativePointer), 0);
    }

    public static Pointer pythonObject(Object object) {
        return new Pointer(new PythonObjectStorage(object), 0);
    }

    private static Storage createStorageInternal(FFIType type, int size, Object value) {
        FFIType.FFI_TYPES t = type.type;
        return switch (t) {
            case FFIType.FFI_TYPES.FFI_TYPE_UINT8, FFIType.FFI_TYPES.FFI_TYPE_SINT8 -> {
                byte[] bytes = new byte[1];
                if (value != null) {
                    bytes[0] = (Byte)value;
                }
                yield new ByteArrayStorage(bytes);
            }
            case FFIType.FFI_TYPES.FFI_TYPE_UINT16, FFIType.FFI_TYPES.FFI_TYPE_SINT16 -> {
                byte[] bytes = new byte[2];
                if (value != null) {
                    PythonUtils.ARRAY_ACCESSOR.putShort(bytes, 0, ((Short)value).shortValue());
                }
                yield new ByteArrayStorage(bytes);
            }
            case FFIType.FFI_TYPES.FFI_TYPE_UINT32, FFIType.FFI_TYPES.FFI_TYPE_SINT32 -> {
                byte[] bytes = new byte[4];
                if (value != null) {
                    PythonUtils.ARRAY_ACCESSOR.putInt(bytes, 0, ((Integer)value).intValue());
                }
                yield new ByteArrayStorage(bytes);
            }
            case FFIType.FFI_TYPES.FFI_TYPE_UINT64, FFIType.FFI_TYPES.FFI_TYPE_SINT64 -> {
                byte[] bytes = new byte[8];
                if (value != null) {
                    PythonUtils.ARRAY_ACCESSOR.putLong(bytes, 0, ((Long)value).longValue());
                }
                yield new ByteArrayStorage(bytes);
            }
            case FFIType.FFI_TYPES.FFI_TYPE_FLOAT -> {
                byte[] bytes = new byte[4];
                if (value != null) {
                    PythonUtils.ARRAY_ACCESSOR.putInt(bytes, 0, Float.floatToRawIntBits(((Float)value).floatValue()));
                }
                yield new ByteArrayStorage(bytes);
            }
            case FFIType.FFI_TYPES.FFI_TYPE_DOUBLE -> {
                byte[] bytes = new byte[8];
                if (value != null) {
                    PythonUtils.ARRAY_ACCESSOR.putLong(bytes, 0, Double.doubleToRawLongBits((Double)value));
                }
                yield new ByteArrayStorage(bytes);
            }
            case FFIType.FFI_TYPES.FFI_TYPE_POINTER, FFIType.FFI_TYPES.FFI_TYPE_STRUCT -> {
                if (value == null) {
                    yield new ZeroStorage(size);
                }
                Pointer valuePtr = Pointer.nativeMemory(value);
                yield new PointerArrayStorage(new Pointer[]{valuePtr});
            }
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Not supported type!");
        };
    }

    public static Pointer create(FFIType type, int size, Object value, int offset) {
        return new Pointer(Pointer.createStorageInternal(type, size, value), offset);
    }

    public static Pointer memoryView(PMemoryView mv) {
        return new Pointer(new MemoryViewStorage(mv), 0);
    }

    public Pointer withOffset(int incOffset) {
        return new Pointer(this.memory, this.offset + incOffset);
    }

    public Pointer createReference() {
        return this.createReference(0);
    }

    public Pointer createReference(int offset) {
        return new Pointer(new PointerArrayStorage(new Pointer[]{this}), offset);
    }

    static final class MemoryBlock {
        Storage storage;

        public MemoryBlock(Storage storage) {
            this.storage = storage;
        }
    }

    static abstract class Storage {
        Storage() {
        }
    }

    static final class ByteArrayStorage
    extends Storage {
        final byte[] bytes;

        ByteArrayStorage(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    static final class LongPointerStorage
    extends Storage {
        final long pointer;

        public LongPointerStorage(long pointer) {
            this.pointer = pointer;
        }
    }

    static final class ObjectPointerStorage
    extends Storage {
        final Object pointer;

        public ObjectPointerStorage(Object pointer) {
            this.pointer = pointer;
        }
    }

    static final class PythonObjectStorage
    extends Storage {
        final Object pythonObject;

        public PythonObjectStorage(Object pythonObject) {
            this.pythonObject = pythonObject;
        }
    }

    static final class ZeroStorage
    extends Storage {
        int size;

        public ZeroStorage(int size) {
            this.size = size;
        }

        void boundsCheck(int offset, int size) {
            if (offset + size > this.size) {
                throw CompilerDirectives.shouldNotReachHere((String)"Out of bounds-read");
            }
        }

        ByteArrayStorage allocateBytes(MemoryBlock memory) {
            ByteArrayStorage newStorage = new ByteArrayStorage(new byte[this.size]);
            memory.storage = newStorage;
            return newStorage;
        }

        PointerArrayStorage allocatePointers(MemoryBlock memory) {
            PointerArrayStorage newStorage = new PointerArrayStorage(new Pointer[(this.size + 7) / 8]);
            memory.storage = newStorage;
            return newStorage;
        }
    }

    static final class PointerArrayStorage
    extends Storage {
        Pointer[] pointers;

        public PointerArrayStorage(Pointer[] pointers) {
            this.pointers = pointers;
        }
    }

    static final class MemoryViewStorage
    extends Storage {
        final PMemoryView memoryView;

        MemoryViewStorage(PMemoryView memoryView) {
            this.memoryView = memoryView;
        }
    }

    static final class NullStorage
    extends Storage {
        NullStorage() {
        }
    }
}

