/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteDecodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteEncodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibytecodecModuleBuiltins;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class MultibyteCodecState {
    protected CoderResult coderResult;

    @CompilerDirectives.TruffleBoundary
    protected static Encoder encoder(Charset charset, TruffleString error) {
        CodingErrorAction errorAction = CodingErrorAction.REPORT;
        errorAction = error == MultibytecodecModuleBuiltins.ERROR_IGNORE ? CodingErrorAction.IGNORE : errorAction;
        errorAction = error == MultibytecodecModuleBuiltins.ERROR_REPLACE ? CodingErrorAction.REPLACE : errorAction;
        return new Encoder(charset, errorAction);
    }

    @CompilerDirectives.TruffleBoundary
    protected static Decoder decoder(Charset charset, TruffleString error) {
        CodingErrorAction errorAction = CodingErrorAction.REPORT;
        errorAction = error == MultibytecodecModuleBuiltins.ERROR_IGNORE ? CodingErrorAction.IGNORE : errorAction;
        errorAction = error == MultibytecodecModuleBuiltins.ERROR_REPLACE ? CodingErrorAction.REPLACE : errorAction;
        return new Decoder(charset, errorAction);
    }

    protected static class Encoder
    extends MultibyteCodecState {
        private final CharsetEncoder encoder;

        Encoder(Charset charset, CodingErrorAction errorAction) {
            this.encoder = charset.newEncoder().onMalformedInput(errorAction).onUnmappableCharacter(errorAction);
        }

        @CompilerDirectives.TruffleBoundary
        public int encode(MultibyteEncodeBuffer buf, int flags) {
            boolean endOfInput = (flags & 1) != 0;
            do {
                this.coderResult = this.encoder.encode(buf.inputBuffer, buf.outputBuffer, endOfInput);
                if (endOfInput && this.coderResult.isUnderflow()) {
                    this.coderResult = this.encoder.flush(buf.outputBuffer);
                }
                if (this.coderResult.isUnderflow()) {
                    buf.outputBuffer.flip();
                    return -2;
                }
                if (!this.coderResult.isOverflow()) continue;
                return -1;
            } while (!this.coderResult.isError());
            return this.coderResult.length();
        }

        @CompilerDirectives.TruffleBoundary
        public int encreset(MultibyteEncodeBuffer buf) {
            int r = this.encode(buf, 1);
            if (r != 0) {
                return r;
            }
            this.encoder.reset();
            return 0;
        }
    }

    protected static class Decoder
    extends MultibyteCodecState {
        private final CharsetDecoder decoder;

        Decoder(Charset charset, CodingErrorAction errorAction) {
            this.decoder = charset.newDecoder().onMalformedInput(errorAction).onUnmappableCharacter(errorAction);
        }

        @CompilerDirectives.TruffleBoundary
        protected int decode(MultibyteDecodeBuffer buf, Node raisingNode) {
            do {
                this.coderResult = this.decoder.decode(buf.inputBuffer, buf.writer, true);
                if (this.coderResult.isUnderflow()) {
                    this.coderResult = this.decoder.flush(buf.writer);
                    buf.writer.flip();
                    return -2;
                }
                if (!this.coderResult.isOverflow()) continue;
                buf.grow(raisingNode);
                return -1;
            } while (!this.coderResult.isError());
            return this.coderResult.length();
        }

        @CompilerDirectives.TruffleBoundary
        protected void decreset() {
            this.decoder.reset();
        }
    }
}

