/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.tools.command.lint.options.LintOptions;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.tools.lint.Lints;
import schemacrawler.tools.lint.formatter.LintTraversalHandler;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseTabularFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.text.options.BaseTextOptions;
import us.fatehi.utility.Color;
import us.fatehi.utility.Multimap;

public final class LintReportTextFormatter
extends BaseTabularFormatter<LintOptions>
implements LintTraversalHandler {
    private Lints report;

    public LintReportTextFormatter(LintOptions lintOptions, OutputOptions outputOptions, Identifiers identifiers) {
        super(SchemaTextDetailType.schema, (BaseTextOptions)lintOptions, outputOptions, identifiers);
    }

    public void handle(Table table) {
        List<Lint<?>> lints = this.report.getLints(table);
        if (lints != null && !lints.isEmpty()) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.println();
            this.formattingHelper.println();
            String tableType = "[" + String.valueOf(table.getTableType()) + "]";
            this.formattingHelper.writeObjectNameRow(this.nodeId((DatabaseObject)table), this.identifiers.quoteFullName((DatabaseObject)table), tableType, this.colorMap.getColor((DatabaseObject)table));
            this.printLints(lints);
            this.formattingHelper.writeObjectEnd();
        }
    }

    public void handleHeaderEnd() {
        Objects.requireNonNull(this.report, "No lint report provided");
        this.handleCatalog();
    }

    public void handleTablesEnd() {
    }

    public void handleTablesStart() {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Table Lints");
    }

    @Override
    public void setReport(Lints report) {
        Objects.requireNonNull(report, "No lint report provided");
        this.report = report;
    }

    private void handleCatalog() {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Database Lints");
        List<Lint<?>> lints = this.report.getCatalogLints();
        if (lints != null && !lints.isEmpty()) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeObjectNameRow("", "Database", "[database]", Color.white);
            this.printLints(lints);
            this.formattingHelper.writeObjectEnd();
        }
    }

    private void printLints(Collection<Lint<?>> lints) {
        this.formattingHelper.writeEmptyRow();
        Multimap multiMap = new Multimap();
        for (Lint<?> lint : lints) {
            multiMap.add((Object)lint.getSeverity(), lint);
        }
        List<LintSeverity> severities = Arrays.asList(LintSeverity.values());
        Collections.reverse(severities);
        for (LintSeverity severity : severities) {
            if (!multiMap.containsKey((Object)severity)) continue;
            this.formattingHelper.writeNameRow("", "[lint, %s]".formatted(new Object[]{severity}));
            ArrayList lintsById = new ArrayList((Collection)multiMap.get((Object)severity));
            for (Lint lint : lintsById) {
                Object lintValue = lint.getValue();
                if (lintValue instanceof Boolean) {
                    Boolean boolean1 = (Boolean)lintValue;
                    if (!boolean1.booleanValue()) continue;
                    this.formattingHelper.writeRow(new Object[]{"", lint.getMessage(), ""});
                    continue;
                }
                this.formattingHelper.writeRow(new Object[]{"", lint.getMessage(), lint.getValueAsString()});
            }
        }
    }
}

