/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Reader;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.utility.BinaryData;
import us.fatehi.utility.EnumUtility;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.IdentifiedEnum;
import us.fatehi.utility.Utility;
import us.fatehi.utility.UtilityLogger;
import us.fatehi.utility.string.StringFormat;

public final class MetadataResultSet
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(MetadataResultSet.class.getName());
    private final ResultsColumns resultsColumns;
    private final ResultSet results;
    private final String description;
    private Set<ResultsColumn> readColumns;
    private int rowCount;
    private boolean showLobs;
    private int maxRows;

    public MetadataResultSet(Query query, Statement statement, Map<String, String> limitMap) throws SQLException {
        this(QueryUtility.executeAgainstSchema(query, statement, limitMap), query.name());
    }

    public MetadataResultSet(ResultSet resultSet, String description) throws SQLException {
        this.results = Objects.requireNonNull(resultSet, "Cannot use null results");
        this.description = Utility.requireNotBlank((String)description, (String)"No result-set description provided");
        this.resultsColumns = new ResultsCrawler(this.results).crawl();
        this.readColumns = new HashSet<ResultsColumn>();
        this.showLobs = true;
        this.maxRows = Integer.MAX_VALUE;
    }

    @Override
    public void close() throws SQLException {
        this.results.close();
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Processed %d rows for <%s>", new Object[]{this.rowCount, this.description}));
    }

    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (ResultsColumn resultsColumn : this.resultsColumns) {
            if (this.readColumns.contains(resultsColumn)) continue;
            try {
                String key = resultsColumn.getLabel().toUpperCase();
                Object value = this.getColumnData(resultsColumn);
                attributes.put(key, value);
            }
            catch (ArrayIndexOutOfBoundsException | SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not read value for column <%s>", new Object[]{resultsColumn}));
            }
        }
        return attributes;
    }

    public BigInteger getBigInteger(String columnName) {
        BigInteger value;
        String stringBigInteger = this.getString(columnName);
        if (Utility.isBlank((String)stringBigInteger)) {
            return null;
        }
        stringBigInteger = stringBigInteger.replaceAll("[, ]", stringBigInteger);
        try {
            value = new BigInteger(stringBigInteger);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not get big integer value", e);
            return null;
        }
        return value;
    }

    public boolean getBoolean(String columnName) {
        if (this.useColumn(columnName)) {
            try {
                Object booleanValue = this.results.getObject(columnName);
                if (this.results.wasNull() || booleanValue == null) {
                    LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("NULL value for column <%s>, so evaluating to 'false'", new Object[]{columnName}));
                    return false;
                }
                String stringBooleanValue = String.valueOf(booleanValue).strip();
                if (Utility.isIntegral((CharSequence)stringBooleanValue)) {
                    return !"0".equals(stringBooleanValue);
                }
                return "yes".equalsIgnoreCase(stringBooleanValue) || "true".equalsIgnoreCase(stringBooleanValue);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not read boolean value for column <%s>", new Object[]{columnName}));
            }
        }
        return false;
    }

    public String[] getColumnNames() {
        ArrayList columnNames = new ArrayList();
        this.resultsColumns.forEach(resultsColumn -> columnNames.add(resultsColumn.getName()));
        return columnNames.toArray(new String[0]);
    }

    public <E extends Enum<E>> E getEnum(String columnName, E defaultValue) {
        Utility.requireNotBlank((String)columnName, (String)"No column name provided");
        Objects.requireNonNull(defaultValue, "No default value provided");
        String value = this.getString(columnName);
        if (Utility.isBlank((String)value)) {
            return defaultValue;
        }
        return (E)EnumUtility.enumValue((String)value.toLowerCase(Locale.ENGLISH), defaultValue);
    }

    public <E extends Enum<E>> E getEnumFromId(String columnName, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        int value = this.getInt(columnName, ((IdentifiedEnum)defaultValue).id());
        return (E)EnumUtility.enumValueFromId((int)value, defaultValue);
    }

    public <E extends Enum<E>> E getEnumFromShortId(String columnName, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        short value = this.getShort(columnName, (short)((IdentifiedEnum)defaultValue).id());
        return (E)EnumUtility.enumValueFromId((int)value, defaultValue);
    }

    public int getInt(String columnName, int defaultValue) {
        int value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getInt(columnName);
                if (this.results.wasNull()) {
                    LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("NULL int value for column <%s>, so using default %d", new Object[]{columnName, defaultValue}));
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not read integer value for column <%s>", new Object[]{columnName}));
            }
        }
        return value;
    }

    public long getLong(String columnName, long defaultValue) {
        long value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getLong(columnName);
                if (this.results.wasNull()) {
                    LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("NULL long value for column <%s>, so using default %d", new Object[]{columnName, defaultValue}));
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not read long value for column <%s>", new Object[]{columnName}));
            }
        }
        return value;
    }

    public short getShort(String columnName, short defaultValue) {
        short value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getShort(columnName);
                if (this.results.wasNull()) {
                    LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("NULL short value for column <%s>, so using default %d", new Object[]{columnName, defaultValue}));
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not read short value for column <%s>", new Object[]{columnName}));
            }
        }
        return value;
    }

    public String getString(String columnName) {
        String value = null;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getString(columnName);
                if (this.results.wasNull()) {
                    value = null;
                }
                if (value != null) {
                    value = value.strip();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not read string value for column <%s>", new Object[]{columnName}));
            }
        }
        return value;
    }

    public boolean next() throws SQLException {
        if (this.rowCount == this.maxRows) {
            return false;
        }
        this.readColumns = new HashSet<ResultsColumn>();
        boolean next = this.results.next();
        new UtilityLogger(LOGGER).logSQLWarnings(this.results);
        if (next) {
            ++this.rowCount;
        }
        return next;
    }

    public void resetMaxRows() {
        this.maxRows = Integer.MAX_VALUE;
    }

    public List<Object> row() throws SQLException {
        ArrayList<Object> currentRow = new ArrayList<Object>();
        for (ResultsColumn resultsColumn : this.resultsColumns) {
            currentRow.add(this.getColumnData(resultsColumn));
        }
        return currentRow;
    }

    public void setMaxRows(int maxRows) {
        if (maxRows < 0) {
            return;
        }
        this.maxRows = maxRows;
    }

    public void setShowLobs(boolean showLobs) {
        this.showLobs = showLobs;
    }

    private Object getColumnData(ResultsColumn resultsColumn) throws SQLException {
        Object columnData;
        int javaSqlType = resultsColumn.getColumnDataType().getJavaSqlType().getVendorTypeNumber();
        int ordinalPosition = resultsColumn.getOrdinalPosition();
        switch (javaSqlType) {
            case -4: 
            case 2004: {
                Object object = this.results.getObject(ordinalPosition);
                if (this.results.wasNull() || object == null) {
                    columnData = null;
                    break;
                }
                columnData = new BinaryData();
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader reader = this.results.getCharacterStream(ordinalPosition);
                if (this.results.wasNull() || reader == null) {
                    columnData = null;
                    break;
                }
                columnData = this.readCharacterData(reader);
                break;
            }
            default: {
                columnData = this.results.getObject(ordinalPosition);
                if (!this.results.wasNull()) break;
                columnData = null;
            }
        }
        return columnData;
    }

    private Object readCharacterData(Reader reader) {
        try {
            if (reader != null && this.showLobs) {
                return IOUtility.readFully((Reader)reader);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not read character data", e);
        }
        return new BinaryData();
    }

    private boolean useColumn(String columnName) {
        Optional optionalResultsColumn = this.resultsColumns.lookupColumn(columnName);
        optionalResultsColumn.ifPresent(this.readColumns::add);
        return optionalResultsColumn.isPresent();
    }
}

