/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.spi;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class NFIState {
    private static final Unsafe UNSAFE;
    private final long nfiErrnoAddress;
    private Throwable pendingException;
    boolean hasPendingException;

    public NFIState(Thread thread) {
        this.nfiErrnoAddress = NFIState.initNfiErrnoAddress(thread);
    }

    public int getNFIErrno() {
        return UNSAFE.getInt(this.nfiErrnoAddress);
    }

    public void setNFIErrno(int nfiErrno) {
        UNSAFE.putInt(this.nfiErrnoAddress, nfiErrno);
    }

    public Throwable getPendingException() {
        return this.pendingException;
    }

    public void setPendingException(Throwable t) {
        assert (t != null);
        this.pendingException = t;
        this.hasPendingException = true;
    }

    public void clearPendingException() {
        this.pendingException = null;
        this.hasPendingException = false;
    }

    private static long initNfiErrnoAddress(Thread thread) {
        long address = UNSAFE.allocateMemory(4L);
        UNSAFE.putInt(address, 0);
        return address;
    }

    private void freeNfiErrnoAddress() {
        UNSAFE.freeMemory(this.nfiErrnoAddress);
    }

    public void dispose() {
        this.freeNfiErrnoAddress();
    }

    static {
        Field unsafeField;
        try {
            unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            UNSAFE = (Unsafe)unsafeField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

