/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http;

import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.Brotli;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.BrotliDecoder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.SnappyFrameDecoder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.Zstd;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.ZstdDecoder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http.HttpContentDecoder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;
    private final int maxAllocation;

    @Deprecated
    public HttpContentDecompressor() {
        this(false, 0);
    }

    public HttpContentDecompressor(int maxAllocation) {
        this(false, maxAllocation);
    }

    @Deprecated
    public HttpContentDecompressor(boolean strict) {
        this(strict, 0);
    }

    public HttpContentDecompressor(boolean strict, int maxAllocation) {
        this.strict = strict;
        this.maxAllocation = ObjectUtil.checkPositiveOrZero(maxAllocation, "maxAllocation");
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP, this.maxAllocation));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(wrapper, this.maxAllocation));
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new BrotliDecoder());
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new SnappyFrameDecoder());
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new ZstdDecoder());
        }
        return null;
    }
}

