/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.HandlerContextAware;
import net.snowflake.client.jdbc.internal.amazonaws.Protocol;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkProtectedApi;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ProviderNameAware;
import net.snowflake.client.jdbc.internal.amazonaws.endpoints.AccountIdEndpointMode;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.HandlerContextKey;
import net.snowflake.client.jdbc.internal.amazonaws.retry.RetryMode;
import net.snowflake.client.jdbc.internal.amazonaws.util.CredentialsProviderNameMapping;
import net.snowflake.client.jdbc.internal.amazonaws.util.HttpClientWrappingInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.util.SdkHttpUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import net.snowflake.client.jdbc.internal.apache.http.HttpHost;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthScope;
import net.snowflake.client.jdbc.internal.apache.http.auth.NTCredentials;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.params.BasicHttpParams;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpConnectionParams;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpProtocolParams;

public class RuntimeHttpUtils {
    private static final String COMMA = ", ";
    private static final String SPACE = " ";
    private static final String AWS_EXECUTION_ENV_PREFIX = "exec-env/";
    private static final String AWS_EXECUTION_ENV_NAME = "AWS_EXECUTION_ENV";
    private static final String RETRY_MODE_PREFIX = "cfg/retry-mode/";
    private static final String PROVIDER_NAME_PREFIX = "cfg/auth-source#";
    public static final String BUSINESS_METADATA_PREFIX = "m/";
    private static final String TRACE_ID_ENVIRONMENT_VARIABLE = "_X_AMZN_TRACE_ID";
    private static final String TRACE_ID_SYSTEM_PROPERTY = "net.snowflake.client.jdbc.internal.amazonaws.xray.traceHeader";
    private static final String LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE = "AWS_LAMBDA_FUNCTION_NAME";

    public static InputStream fetchFile(URI uri, ClientConfiguration config) throws IOException {
        CloseableHttpResponse response;
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(httpClientParams, RuntimeHttpUtils.getUserAgent(config, null));
        HttpConnectionParams.setConnectionTimeout(httpClientParams, RuntimeHttpUtils.getConnectionTimeout(config));
        HttpConnectionParams.setSoTimeout(httpClientParams, RuntimeHttpUtils.getSocketTimeout(config));
        DefaultHttpClient httpclient = new DefaultHttpClient(httpClientParams);
        if (config != null) {
            String proxyHost = config.getProxyHost();
            int proxyPort = config.getProxyPort();
            if (proxyHost != null && proxyPort > 0) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpclient.getParams().setParameter("http.route.default-proxy", proxy);
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(config.getProxyUsername(), config.getProxyPassword(), config.getProxyWorkstation(), config.getProxyDomain()));
                }
            }
        }
        if ((response = httpclient.execute(new HttpGet(uri))).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Error fetching file from " + uri + ": " + response);
        }
        return new HttpClientWrappingInputStream(httpclient, response.getEntity().getContent());
    }

    public static String getUserAgent(ClientConfiguration config, String userAgentMarker) {
        return RuntimeHttpUtils.getUserAgent(config, userAgentMarker, null);
    }

    public static String getUserAgent(ClientConfiguration config, String userAgentMarker, AWSCredentials credentials) {
        return RuntimeHttpUtils.getUserAgent(config, userAgentMarker, credentials, null);
    }

    public static String getUserAgent(ClientConfiguration config, String userAgentMarker, AWSCredentials credentials, HandlerContextAware request) {
        String userDefinedPrefix = "";
        String userDefinedSuffix = "";
        String retryModeName = "";
        String awsExecutionEnvironment = RuntimeHttpUtils.getEnvironmentVariable(AWS_EXECUTION_ENV_NAME);
        String providerName = RuntimeHttpUtils.getProviderName(credentials);
        String businessMetrics = RuntimeHttpUtils.getBusinessMetrics(request);
        if (config != null) {
            userDefinedPrefix = config.getUserAgentPrefix();
            userDefinedSuffix = config.getUserAgentSuffix();
            RetryMode retryMode = config.getRetryMode() == null ? config.getRetryPolicy().getRetryMode() : config.getRetryMode();
            retryModeName = retryMode != null ? retryMode.getName() : "";
        }
        StringBuilder userAgent = new StringBuilder(userDefinedPrefix.trim());
        if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(userDefinedPrefix)) {
            userAgent.append(COMMA).append(ClientConfiguration.DEFAULT_USER_AGENT);
        }
        if (StringUtils.hasValue(retryModeName)) {
            userAgent.append(SPACE).append(RETRY_MODE_PREFIX).append(retryModeName.trim());
        }
        if (StringUtils.hasValue(providerName)) {
            userAgent.append(SPACE).append(PROVIDER_NAME_PREFIX).append(providerName);
        }
        if (StringUtils.hasValue(businessMetrics)) {
            userAgent.append(SPACE).append(BUSINESS_METADATA_PREFIX).append(businessMetrics);
        }
        if (StringUtils.hasValue(userDefinedSuffix)) {
            userAgent.append(COMMA).append(userDefinedSuffix.trim());
        }
        if (StringUtils.hasValue(awsExecutionEnvironment)) {
            userAgent.append(SPACE).append(AWS_EXECUTION_ENV_PREFIX).append(awsExecutionEnvironment.trim());
        }
        if (StringUtils.hasValue(userAgentMarker)) {
            userAgent.append(SPACE).append(userAgentMarker.trim());
        }
        return userAgent.toString();
    }

    private static String getProviderName(AWSCredentials credentials) {
        if (credentials instanceof ProviderNameAware) {
            ProviderNameAware providerNameAwareCredentials = (ProviderNameAware)((Object)credentials);
            return CredentialsProviderNameMapping.mapFrom(providerNameAwareCredentials.getProviderName());
        }
        return null;
    }

    private static String getBusinessMetrics(HandlerContextAware request) {
        String resolvedAccountId;
        AccountIdEndpointMode accountIdEndpointMode;
        if (request == null) {
            return null;
        }
        ArrayList<String> recordedMetric = new ArrayList<String>();
        Boolean isEndpointOverridden = request.getHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN);
        if (Boolean.TRUE.equals(isEndpointOverridden)) {
            recordedMetric.add("N");
        }
        if ((accountIdEndpointMode = request.getHandlerContext(HandlerContextKey.ACCOUNT_ID_ENDPOINT_MODE)) != null) {
            switch (accountIdEndpointMode) {
                case PREFERRED: {
                    recordedMetric.add("P");
                    break;
                }
                case REQUIRED: {
                    recordedMetric.add("R");
                    break;
                }
                case DISABLED: {
                    recordedMetric.add("Q");
                    break;
                }
            }
        }
        if ((resolvedAccountId = request.getHandlerContext(HandlerContextKey.AWS_CREDENTIALS_ACCOUNT_ID)) != null) {
            recordedMetric.add("T");
        }
        return String.join((CharSequence)",", recordedMetric);
    }

    private static String getEnvironmentVariable(String environmentVariableName) {
        try {
            return System.getenv(environmentVariableName);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getSystemProperty(String systemProperty) {
        try {
            return System.getProperty(systemProperty);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int getConnectionTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getConnectionTimeout();
        }
        return 10000;
    }

    private static int getSocketTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getSocketTimeout();
        }
        return 50000;
    }

    public static URI toUri(String endpoint, ClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("ClientConfiguration cannot be null");
        }
        return RuntimeHttpUtils.toUri(endpoint, config.getProtocol());
    }

    public static URI toUri(String endpoint, Protocol protocol) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        if (!endpoint.contains("://")) {
            endpoint = protocol.toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @SdkProtectedApi
    public static URL convertRequestToUrl(Request<?> request, boolean removeLeadingSlashInResourcePath, boolean urlEncode) {
        String resourcePath;
        String string = resourcePath = urlEncode ? SdkHttpUtils.urlEncode(request.getResourcePath(), true) : request.getResourcePath();
        if (removeLeadingSlashInResourcePath && resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        String urlPath = "/" + resourcePath;
        urlPath = urlPath.replaceAll("(?<=/)/", "%2F");
        StringBuilder url = new StringBuilder(request.getEndpoint().toString());
        url.append(urlPath);
        StringBuilder queryParams = new StringBuilder();
        Map<String, List<String>> requestParams = request.getParameters();
        for (Map.Entry<String, List<String>> entry : requestParams.entrySet()) {
            for (String value : entry.getValue()) {
                queryParams = queryParams.length() > 0 ? queryParams.append("&") : queryParams.append("?");
                queryParams.append(SdkHttpUtils.urlEncode(entry.getKey(), false)).append("=").append(SdkHttpUtils.urlEncode(value, false));
            }
        }
        url.append(queryParams.toString());
        try {
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new SdkClientException("Unable to convert request to well formed URL: " + e.getMessage(), e);
        }
    }

    public static String getLambdaEnvironmentTraceId() {
        String lambdafunctionName = RuntimeHttpUtils.getEnvironmentVariable(LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE);
        String traceId = RuntimeHttpUtils.traceId();
        if (!StringUtils.isNullOrEmpty(lambdafunctionName) && !StringUtils.isNullOrEmpty(traceId)) {
            return traceId;
        }
        return null;
    }

    static String traceId() {
        String traceId = RuntimeHttpUtils.getSystemProperty(TRACE_ID_SYSTEM_PROPERTY);
        if (traceId == null) {
            traceId = RuntimeHttpUtils.getEnvironmentVariable(TRACE_ID_ENVIRONMENT_VARIABLE);
        }
        return traceId;
    }
}

