/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetry;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class PreSessionTelemetryClient
implements Telemetry {
    private static final SFLogger logger = SFLoggerFactory.getLogger(PreSessionTelemetryClient.class);
    private final List<TelemetryData> bufferedData = new ArrayList<TelemetryData>();
    private final Lock lock = new ReentrantLock();
    private Telemetry realTelemetryClient = null;
    private boolean closed = false;
    private static final int MAX_BUFFER_SIZE = 1000;

    @Override
    public void addLogToBatch(TelemetryData log) {
        if (this.closed || log == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.realTelemetryClient != null) {
                this.realTelemetryClient.addLogToBatch(log);
            } else if (this.bufferedData.size() < 1000) {
                this.bufferedData.add(log);
                logger.debug("Buffered telemetry data, buffer size: {}", this.bufferedData.size());
            } else {
                logger.debug("Telemetry buffer full (size: {}), dropping telemetry data to prevent memory issues", 1000);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRealTelemetryClient(Telemetry realClient) {
        this.lock.lock();
        try {
            if (this.closed) {
                logger.debug("PreSessionTelemetryClient is closed, ignoring real client", new Object[0]);
                return;
            }
            this.realTelemetryClient = realClient;
            this.flushBufferedData(realClient);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void flushBufferedData(Telemetry realClient) {
        for (TelemetryData data : this.bufferedData) {
            try {
                realClient.addLogToBatch(data);
            }
            catch (Exception e) {
                logger.debug("Failed to flush buffered telemetry data: {}", e.getMessage());
            }
        }
        this.bufferedData.clear();
    }

    @Override
    public Future<Boolean> sendBatchAsync() {
        this.lock.lock();
        try {
            if (this.realTelemetryClient != null) {
                Future<Boolean> future = this.realTelemetryClient.sendBatchAsync();
                return future;
            }
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
            return completableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.realTelemetryClient != null) {
                try {
                    this.realTelemetryClient.close();
                }
                catch (Exception e) {
                    logger.debug("Error closing telemetry client: {}", e.getMessage());
                }
            }
            if (!this.bufferedData.isEmpty()) {
                logger.debug("Closing PreSessionTelemetryClient with {} unflushed entries", this.bufferedData.size());
            }
            this.bufferedData.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postProcess(String queryId, String sqlState, int vendorCode, Throwable ex) {
        this.lock.lock();
        try {
            if (this.realTelemetryClient != null) {
                this.realTelemetryClient.postProcess(queryId, sqlState, vendorCode, ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasRealTelemetryClient() {
        return this.realTelemetryClient != null;
    }
}

