/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import java.time.Duration;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DurationVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.DurationWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.DurationHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDurationHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;

public class DurationHolderReaderImpl
extends AbstractFieldReader {
    private DurationHolder holder;

    public DurationHolderReaderImpl(DurationHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DURATION;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(DurationHolder h2) {
        h2.value = this.holder.value;
        h2.unit = this.holder.unit;
    }

    @Override
    public void read(NullableDurationHolder h2) {
        h2.value = this.holder.value;
        h2.unit = this.holder.unit;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Duration readDuration() {
        return DurationVector.toDuration(this.holder.value, this.holder.unit);
    }

    @Override
    public Object readObject() {
        return this.readDuration();
    }

    @Override
    public void copyAsValue(DurationWriter writer) {
        writer.write(this.holder);
    }
}

