/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import net.snowflake.client.jdbc.internal.amazonaws.internal.SdkInternalList;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.KeyAgreementAlgorithmSpec;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.RecipientInfo;

public class DeriveSharedSecretRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyId;
    private String keyAgreementAlgorithm;
    private ByteBuffer publicKey;
    private SdkInternalList<String> grantTokens;
    private Boolean dryRun;
    private RecipientInfo recipient;

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public DeriveSharedSecretRequest withKeyId(String keyId) {
        this.setKeyId(keyId);
        return this;
    }

    public void setKeyAgreementAlgorithm(String keyAgreementAlgorithm) {
        this.keyAgreementAlgorithm = keyAgreementAlgorithm;
    }

    public String getKeyAgreementAlgorithm() {
        return this.keyAgreementAlgorithm;
    }

    public DeriveSharedSecretRequest withKeyAgreementAlgorithm(String keyAgreementAlgorithm) {
        this.setKeyAgreementAlgorithm(keyAgreementAlgorithm);
        return this;
    }

    public DeriveSharedSecretRequest withKeyAgreementAlgorithm(KeyAgreementAlgorithmSpec keyAgreementAlgorithm) {
        this.keyAgreementAlgorithm = keyAgreementAlgorithm.toString();
        return this;
    }

    public void setPublicKey(ByteBuffer publicKey) {
        this.publicKey = publicKey;
    }

    public ByteBuffer getPublicKey() {
        return this.publicKey;
    }

    public DeriveSharedSecretRequest withPublicKey(ByteBuffer publicKey) {
        this.setPublicKey(publicKey);
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> grantTokens) {
        if (grantTokens == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(grantTokens);
    }

    public DeriveSharedSecretRequest withGrantTokens(String ... grantTokens) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(grantTokens.length));
        }
        for (String ele : grantTokens) {
            this.grantTokens.add(ele);
        }
        return this;
    }

    public DeriveSharedSecretRequest withGrantTokens(Collection<String> grantTokens) {
        this.setGrantTokens(grantTokens);
        return this;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public DeriveSharedSecretRequest withDryRun(Boolean dryRun) {
        this.setDryRun(dryRun);
        return this;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setRecipient(RecipientInfo recipient) {
        this.recipient = recipient;
    }

    public RecipientInfo getRecipient() {
        return this.recipient;
    }

    public DeriveSharedSecretRequest withRecipient(RecipientInfo recipient) {
        this.setRecipient(recipient);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyId() != null) {
            sb.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getKeyAgreementAlgorithm() != null) {
            sb.append("KeyAgreementAlgorithm: ").append(this.getKeyAgreementAlgorithm()).append(",");
        }
        if (this.getPublicKey() != null) {
            sb.append("PublicKey: ").append(this.getPublicKey()).append(",");
        }
        if (this.getGrantTokens() != null) {
            sb.append("GrantTokens: ").append(this.getGrantTokens()).append(",");
        }
        if (this.getDryRun() != null) {
            sb.append("DryRun: ").append(this.getDryRun()).append(",");
        }
        if (this.getRecipient() != null) {
            sb.append("Recipient: ").append(this.getRecipient());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeriveSharedSecretRequest)) {
            return false;
        }
        DeriveSharedSecretRequest other = (DeriveSharedSecretRequest)obj;
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (other.getKeyId() != null && !other.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (other.getKeyAgreementAlgorithm() == null ^ this.getKeyAgreementAlgorithm() == null) {
            return false;
        }
        if (other.getKeyAgreementAlgorithm() != null && !other.getKeyAgreementAlgorithm().equals(this.getKeyAgreementAlgorithm())) {
            return false;
        }
        if (other.getPublicKey() == null ^ this.getPublicKey() == null) {
            return false;
        }
        if (other.getPublicKey() != null && !other.getPublicKey().equals(this.getPublicKey())) {
            return false;
        }
        if (other.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        if (other.getGrantTokens() != null && !other.getGrantTokens().equals(this.getGrantTokens())) {
            return false;
        }
        if (other.getDryRun() == null ^ this.getDryRun() == null) {
            return false;
        }
        if (other.getDryRun() != null && !other.getDryRun().equals(this.getDryRun())) {
            return false;
        }
        if (other.getRecipient() == null ^ this.getRecipient() == null) {
            return false;
        }
        return other.getRecipient() == null || other.getRecipient().equals(this.getRecipient());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAgreementAlgorithm() == null ? 0 : this.getKeyAgreementAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getPublicKey() == null ? 0 : this.getPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        hashCode = 31 * hashCode + (this.getDryRun() == null ? 0 : this.getDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getRecipient() == null ? 0 : this.getRecipient().hashCode());
        return hashCode;
    }

    @Override
    public DeriveSharedSecretRequest clone() {
        return (DeriveSharedSecretRequest)super.clone();
    }
}

