/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal;

import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.Immutable;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfile;
import net.snowflake.client.jdbc.internal.amazonaws.internal.StaticCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;

@SdkInternalApi
@Immutable
public class ProfileStaticCredentialsProvider
implements AWSCredentialsProvider {
    private final BasicProfile profile;
    private final AWSCredentialsProvider credentialsProvider;

    public ProfileStaticCredentialsProvider(BasicProfile profile) {
        this.profile = profile;
        this.credentialsProvider = new StaticCredentialsProvider(this.fromStaticCredentials());
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsProvider.getCredentials();
    }

    @Override
    public void refresh() {
    }

    private AWSCredentials fromStaticCredentials() {
        if (StringUtils.isNullOrEmpty(this.profile.getAwsAccessIdKey())) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Access Key ID is not specified.", this.profile.getProfileName()));
        }
        if (StringUtils.isNullOrEmpty(this.profile.getAwsSecretAccessKey())) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Secret Access Key is not specified.", this.profile.getAwsSecretAccessKey()));
        }
        if (this.profile.getAwsSessionToken() == null) {
            return new BasicAWSCredentials(this.profile.getAwsAccessIdKey(), this.profile.getAwsSecretAccessKey(), this.profile.getAwsAccountId());
        }
        if (this.profile.getAwsSessionToken().isEmpty()) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Session Token is empty.", this.profile.getProfileName()));
        }
        return new BasicSessionCredentials(this.profile.getAwsAccessIdKey(), this.profile.getAwsSecretAccessKey(), this.profile.getAwsSessionToken(), this.profile.getAwsAccountId());
    }
}

