/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.wif;

import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.EnvironmentVariables;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWS4Signer;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSStaticCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import net.snowflake.client.jdbc.internal.amazonaws.regions.InstanceMetadataRegionProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.AWSSecurityTokenService;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.model.AssumeRoleResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.model.Credentials;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class AwsAttestationService {
    public static final SFLogger logger = SFLoggerFactory.getLogger(AwsAttestationService.class);
    private static boolean regionInitialized = false;
    private static String region;
    private final AWS4Signer aws4Signer = new AWS4Signer();

    void initializeSignerRegion() {
        this.aws4Signer.setRegionName(this.getAWSRegion());
    }

    public AWSCredentials getAWSCredentials() {
        try {
            return DefaultAWSCredentialsProviderChain.getInstance().getCredentials();
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve AWS credentials: {}", e.getMessage());
            return null;
        }
    }

    String getAWSRegion() {
        if (!regionInitialized) {
            logger.debug("Getting AWS region from environment variable", new Object[0]);
            String envRegion = SnowflakeUtil.systemGetEnv(EnvironmentVariables.AWS_REGION.getName());
            if (envRegion != null) {
                region = envRegion;
            } else {
                logger.debug("Getting AWS region from EC2 metadata service", new Object[0]);
                region = new InstanceMetadataRegionProvider().getRegion();
            }
            regionInitialized = true;
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCallerIdentityArn(AWSCredentials credentials, int timeoutMs) {
        if (credentials == null) {
            logger.debug("Cannot get caller identity with null credentials", new Object[0]);
            return null;
        }
        String region = this.getAWSRegion();
        if (region == null || region.trim().isEmpty()) {
            logger.debug("Cannot get caller identity without AWS region", new Object[0]);
            return null;
        }
        AWSSecurityTokenService stsClient = null;
        try {
            stsClient = this.createStsClient(credentials, timeoutMs);
            GetCallerIdentityResult callerIdentity = stsClient.getCallerIdentity(new GetCallerIdentityRequest());
            if (callerIdentity == null || callerIdentity.getArn() == null) {
                logger.debug("GetCallerIdentity returned null or missing ARN", new Object[0]);
                String string = null;
                return string;
            }
            String string = callerIdentity.getArn();
            return string;
        }
        catch (Exception e) {
            logger.debug("Failed to get caller identity ARN: {}", e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (stsClient != null) {
                stsClient.shutdown();
            }
        }
    }

    void signRequestWithSigV4(Request<Void> signableRequest, AWSCredentials awsCredentials) {
        this.aws4Signer.setServiceName(signableRequest.getServiceName());
        this.aws4Signer.sign(signableRequest, awsCredentials);
    }

    AWSCredentials assumeRole(AWSCredentials currentCredentials, String roleArn) throws SFException {
        AWSSecurityTokenService stsClient = null;
        try {
            stsClient = this.createStsClient(currentCredentials, null);
            AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(roleArn).withRoleSessionName("identity-federation-session");
            AssumeRoleResult assumeRoleResult = stsClient.assumeRole(assumeRoleRequest);
            Credentials credentials = assumeRoleResult.getCredentials();
            logger.debug("Successfully assumed role: {}", roleArn);
            BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
            return basicSessionCredentials;
        }
        catch (Exception e) {
            logger.error("Failed to assume role: {} - {}", roleArn, e.getMessage());
            throw new SFException(ErrorCode.WORKLOAD_IDENTITY_FLOW_ERROR, "Failed to assume AWS role " + roleArn + ": " + e.getMessage());
        }
        finally {
            if (stsClient != null) {
                stsClient.shutdown();
            }
        }
    }

    AWSCredentials getCredentialsViaRoleChaining(SFLoginInput loginInput) throws SFException {
        AWSCredentials currentCredentials = this.getAWSCredentials();
        if (currentCredentials == null) {
            throw new SFException(ErrorCode.WORKLOAD_IDENTITY_FLOW_ERROR, "No initial AWS credentials found for role chaining");
        }
        for (String roleArn : loginInput.getWorkloadIdentityImpersonationPath()) {
            logger.debug("Assuming role: {}", roleArn);
            if ((currentCredentials = this.assumeRole(currentCredentials, roleArn)) != null) continue;
            throw new SFException(ErrorCode.WORKLOAD_IDENTITY_FLOW_ERROR, "Failed to assume role: " + roleArn);
        }
        return currentCredentials;
    }

    private AWSSecurityTokenService createStsClient(AWSCredentials credentials, Integer timeoutMs) {
        AWSSecurityTokenServiceClientBuilder builder = (AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(new AWSStaticCredentialsProvider(credentials))).withRegion(this.getAWSRegion());
        if (timeoutMs != null) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setConnectionTimeout(timeoutMs);
            clientConfiguration.setRequestTimeout(timeoutMs);
            clientConfiguration.setClientExecutionTimeout(timeoutMs);
            clientConfiguration.setMaxErrorRetry(0);
            builder.withClientConfiguration(clientConfiguration);
        }
        return (AWSSecurityTokenService)builder.build();
    }
}

