/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import schemacrawler.loader.attributes.model.ColumnAttributes;
import schemacrawler.loader.attributes.model.ObjectAttributes;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaReference;

public class TableAttributes
extends ObjectAttributes
implements Iterable<ColumnAttributes> {
    private static final long serialVersionUID = -3510286847668145323L;
    private final String schemaName;
    private final String catalogName;
    private final List<ColumnAttributes> columns;

    @ConstructorProperties(value={"schema", "catalog", "name", "remarks", "attributes", "columns"})
    public TableAttributes(String schemaName, String catalogName, String name, List<String> remarks, Map<String, String> attributes, List<ColumnAttributes> columns) {
        super(name, remarks, attributes);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.columns = columns == null ? Collections.emptyList() : Collections.unmodifiableList(columns);
    }

    public Schema getSchema() {
        return new SchemaReference(this.catalogName, this.schemaName);
    }

    @Override
    public Iterator<ColumnAttributes> iterator() {
        return this.columns.iterator();
    }

    @Override
    public String toString() {
        return "Table attributes <%s.%s.%s>".formatted(this.schemaName, this.catalogName, this.getName());
    }
}

