/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.json;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.json.JSONModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.json.JSONScannerBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONUtils;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;

@CoreFunctions(defineModule="_json")
public final class JSONModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return JSONModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"json speedups\n");
        this.addBuiltinConstant("make_scanner", (Object)core.lookupType(PythonBuiltinClassType.JSONScanner));
        this.addBuiltinConstant("make_encoder", (Object)core.lookupType(PythonBuiltinClassType.JSONEncoder));
        super.initialize(core);
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    @Builtin(name="encode_basestring_ascii", parameterNames={"string"}, doc="encode_basestring_ascii(string) -> string\n\nReturn an ASCII-only JSON representation of a Python string")
    @GenerateNodeFactory
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    static abstract class EncodeBaseStringAscii
    extends PythonUnaryClinicBuiltinNode {
        EncodeBaseStringAscii() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONModuleBuiltinsClinicProviders.EncodeBaseStringAsciiClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString call(TruffleString string, @Bind Node inliningTarget, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PRaiseNode raiseNode) {
            try {
                int len = string.byteLength(PythonUtils.TS_ENCODING);
                TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(len + (len >> 3) + 2));
                JSONUtils.appendString(string, createCodePointIteratorNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING), builder, true, nextNode, appendCodePointNode, appendStringNode, substringNode);
                return toStringNode.execute(builder);
            }
            catch (NegativeArraySizeException | OutOfMemoryError e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.STR_TOO_LONG_TO_ESCAPE);
            }
        }
    }

    @Builtin(name="encode_basestring", parameterNames={"string"}, doc="encode_basestring(string) -> string\n\nReturn a JSON representation of a Python string")
    @GenerateNodeFactory
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    static abstract class EncodeBaseString
    extends PythonUnaryClinicBuiltinNode {
        EncodeBaseString() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONModuleBuiltinsClinicProviders.EncodeBaseStringClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString call(TruffleString string, @Bind Node inliningTarget, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PRaiseNode raiseNode) {
            try {
                int len = string.byteLength(PythonUtils.TS_ENCODING);
                TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(len + (len >> 3) + 2));
                JSONUtils.appendString(string, createCodePointIteratorNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING), builder, false, nextNode, appendCodePointNode, appendStringNode, substringNode);
                return toStringNode.execute(builder);
            }
            catch (NegativeArraySizeException | OutOfMemoryError e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.STR_TOO_LONG_TO_ESCAPE);
            }
        }
    }

    @Builtin(name="scanstring", minNumOfPositionalArgs=2, parameterNames={"string", "end", "strict"}, doc="scanstring(string, end, strict=True) -> (string, end)\n\nScan the string s for a JSON string. End is the index of the\ncharacter in s after the quote that started the JSON string.\nUnescapes all valid JSON string escape sequences and raises ValueError\non attempt to decode an invalid string. If strict is False then literal\ncontrol characters are allowed in the string.\n\nReturns a tuple of the decoded string and the index of the character in s\nafter the end quote.")
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="strict", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="true", useDefaultForNone=true)})
    static abstract class ScanString
    extends PythonTernaryClinicBuiltinNode {
        ScanString() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONModuleBuiltinsClinicProviders.ScanStringClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object call(Object string, int end, boolean strict, @Bind Node inliningTarget, @Cached StringNodes.CastToJavaStringCheckedNode castString, @Bind PythonLanguage language) {
            JSONScannerBuiltins.IntRef nextIdx = new JSONScannerBuiltins.IntRef();
            TruffleString result = JSONScannerBuiltins.scanStringUnicode(castString.cast(inliningTarget, string, ErrorMessages.FIRST_ARG_MUST_BE_STRING_NOT_P, string), end, strict, nextIdx, this);
            return PFactory.createTuple(language, new Object[]{result, nextIdx.value});
        }
    }
}

