/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopKnnCollector;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.hnsw.AbstractHnswGraphSearcher;
import org.apache.lucene.util.hnsw.FilteredHnswGraphSearcher;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.NeighborQueue;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.SeededHnswGraphSearcher;

public class HnswGraphSearcher
extends AbstractHnswGraphSearcher {
    protected final NeighborQueue candidates;
    protected BitSet visited;

    public HnswGraphSearcher(NeighborQueue candidates, BitSet visited) {
        this.candidates = candidates;
        this.visited = visited;
    }

    public static void search(RandomVectorScorer scorer, KnnCollector knnCollector, HnswGraph graph, Bits acceptOrds) throws IOException {
        int filteredDocCount = 0;
        if (acceptOrds instanceof BitSet) {
            BitSet bitSet = (BitSet)acceptOrds;
            filteredDocCount = Math.min(bitSet.approximateCardinality(), graph.size());
        }
        HnswGraphSearcher.search(scorer, knnCollector, graph, acceptOrds, filteredDocCount);
    }

    public static void search(RandomVectorScorer scorer, KnnCollector knnCollector, HnswGraph graph, Bits acceptOrds, int filteredDocCount) throws IOException {
        KnnSearchStrategy.Seeded seeded;
        KnnSearchStrategy.Hnsw hnsw;
        KnnSearchStrategy.Seeded seeded2;
        KnnSearchStrategy.Hnsw hnsw2;
        assert (filteredDocCount >= 0 && filteredDocCount <= graph.size());
        KnnSearchStrategy knnSearchStrategy = knnCollector.getSearchStrategy();
        KnnSearchStrategy.Hnsw hnswStrategy = knnSearchStrategy instanceof KnnSearchStrategy.Hnsw ? (hnsw2 = (KnnSearchStrategy.Hnsw)knnSearchStrategy) : ((knnSearchStrategy = knnCollector.getSearchStrategy()) instanceof KnnSearchStrategy.Seeded && (knnSearchStrategy = (seeded2 = (KnnSearchStrategy.Seeded)knnSearchStrategy).originalStrategy()) instanceof KnnSearchStrategy.Hnsw ? (hnsw = (KnnSearchStrategy.Hnsw)knnSearchStrategy) : KnnSearchStrategy.Hnsw.DEFAULT);
        HnswGraphSearcher innerSearcher = acceptOrds != null && graph.maxConn() != -1 && filteredDocCount > 0 && hnswStrategy.useFilteredSearch((float)filteredDocCount / (float)graph.size()) ? FilteredHnswGraphSearcher.create(knnCollector.k(), graph, filteredDocCount, acceptOrds) : new HnswGraphSearcher(new NeighborQueue(knnCollector.k(), true), new SparseFixedBitSet(HnswGraphSearcher.getGraphSize(graph)));
        knnSearchStrategy = knnCollector.getSearchStrategy();
        AbstractHnswGraphSearcher graphSearcher = knnSearchStrategy instanceof KnnSearchStrategy.Seeded && (seeded = (KnnSearchStrategy.Seeded)knnSearchStrategy).numberOfEntryPoints() > 0 ? SeededHnswGraphSearcher.fromEntryPoints(innerSearcher, seeded.numberOfEntryPoints(), seeded.entryPoints(), graph.size()) : innerSearcher;
        ((AbstractHnswGraphSearcher)graphSearcher).search(knnCollector, scorer, graph, acceptOrds);
    }

    public static KnnCollector search(RandomVectorScorer scorer, int topK, OnHeapHnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        TopKnnCollector knnCollector = new TopKnnCollector(topK, visitedLimit, null);
        OnHeapHnswGraphSearcher graphSearcher = new OnHeapHnswGraphSearcher(new NeighborQueue(topK, true), new SparseFixedBitSet(HnswGraphSearcher.getGraphSize(graph)));
        graphSearcher.search(knnCollector, scorer, graph, acceptOrds);
        return knnCollector;
    }

    public HnswGraphBuilder.GraphBuilderKnnCollector searchLevel(RandomVectorScorer scorer, int topK, int level, int[] eps, HnswGraph graph) throws IOException {
        HnswGraphBuilder.GraphBuilderKnnCollector results = new HnswGraphBuilder.GraphBuilderKnnCollector(topK);
        this.searchLevel(results, scorer, level, eps, graph, null);
        return results;
    }

    @Override
    int[] findBestEntryPoint(RandomVectorScorer scorer, HnswGraph graph, KnnCollector collector) throws IOException {
        int[] nArray;
        int currentEp = graph.entryNode();
        if (currentEp == -1 || graph.numLevels() == 1) {
            return new int[]{currentEp};
        }
        int size = HnswGraphSearcher.getGraphSize(graph);
        this.prepareScratchState(size);
        float currentScore = scorer.score(currentEp);
        collector.incVisitedCount(1);
        for (int level = graph.numLevels() - 1; level >= 1; --level) {
            boolean foundBetter = true;
            this.visited.set(currentEp);
            while (foundBetter) {
                int friendOrd;
                foundBetter = false;
                this.graphSeek(graph, level, currentEp);
                while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                    assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                    if (this.visited.getAndSet(friendOrd)) continue;
                    if (collector.earlyTerminated()) {
                        return new int[]{-1};
                    }
                    float friendSimilarity = scorer.score(friendOrd);
                    collector.incVisitedCount(1);
                    if (!(friendSimilarity > currentScore)) continue;
                    currentScore = friendSimilarity;
                    currentEp = friendOrd;
                    foundBetter = true;
                }
            }
        }
        if (collector.earlyTerminated()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = currentEp;
        }
        return nArray;
    }

    @Override
    void searchLevel(KnnCollector results, RandomVectorScorer scorer, int level, int[] eps, HnswGraph graph, Bits acceptOrds) throws IOException {
        int size = HnswGraphSearcher.getGraphSize(graph);
        this.prepareScratchState(size);
        for (int ep : eps) {
            if (this.visited.getAndSet(ep)) continue;
            if (results.earlyTerminated()) break;
            float score = scorer.score(ep);
            results.incVisitedCount(1);
            this.candidates.add(ep, score);
            if (acceptOrds != null && !acceptOrds.get(ep)) continue;
            results.collect(ep, score);
        }
        float minAcceptedSimilarity = Math.nextUp(results.minCompetitiveSimilarity());
        boolean shouldExploreMinSim = true;
        while (this.candidates.size() > 0 && !results.earlyTerminated()) {
            int friendOrd;
            float topCandidateSimilarity = this.candidates.topScore();
            if (topCandidateSimilarity < minAcceptedSimilarity) {
                if (!shouldExploreMinSim || Math.nextUp(topCandidateSimilarity) != minAcceptedSimilarity) break;
                shouldExploreMinSim = false;
            }
            int topCandidateNode = this.candidates.pop();
            this.graphSeek(graph, level, topCandidateNode);
            while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (this.visited.getAndSet(friendOrd)) continue;
                if (results.earlyTerminated()) break;
                float friendSimilarity = scorer.score(friendOrd);
                results.incVisitedCount(1);
                if (!(friendSimilarity >= minAcceptedSimilarity)) continue;
                this.candidates.add(friendOrd, friendSimilarity);
                if (acceptOrds != null && !acceptOrds.get(friendOrd) || !results.collect(friendOrd, friendSimilarity)) continue;
                float oldMinAcceptedSimilarity = minAcceptedSimilarity;
                minAcceptedSimilarity = Math.nextUp(results.minCompetitiveSimilarity());
                if (!(minAcceptedSimilarity > oldMinAcceptedSimilarity)) continue;
                shouldExploreMinSim = true;
            }
            if (results.getSearchStrategy() == null) continue;
            results.getSearchStrategy().nextVectorsBlock();
        }
    }

    private void prepareScratchState(int capacity) {
        this.candidates.clear();
        if (this.visited.length() < capacity) {
            this.visited = FixedBitSet.ensureCapacity((FixedBitSet)this.visited, capacity);
        }
        this.visited.clear();
    }

    void graphSeek(HnswGraph graph, int level, int targetNode) throws IOException {
        graph.seek(level, targetNode);
    }

    int graphNextNeighbor(HnswGraph graph) throws IOException {
        return graph.nextNeighbor();
    }

    static int getGraphSize(HnswGraph graph) {
        return graph.maxNodeId() + 1;
    }

    private static class OnHeapHnswGraphSearcher
    extends HnswGraphSearcher {
        private NeighborArray cur;
        private int upto;

        private OnHeapHnswGraphSearcher(NeighborQueue candidates, BitSet visited) {
            super(candidates, visited);
        }

        @Override
        void graphSeek(HnswGraph graph, int level, int targetNode) {
            this.cur = ((OnHeapHnswGraph)graph).getNeighbors(level, targetNode);
            this.upto = -1;
        }

        @Override
        int graphNextNeighbor(HnswGraph graph) {
            if (++this.upto < this.cur.size()) {
                return this.cur.nodes()[this.upto];
            }
            return Integer.MAX_VALUE;
        }
    }
}

