/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6PrimaryConstructorOptimizationLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6PrimaryConstructorOptimizationLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000eH\u0002J3\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0007\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\u00160\u0015H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "convertToRegularConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "removeConstructorForExport", "", "withoutFirst", "T", "", "predicate", "Lkotlin/Function1;", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6PrimaryConstructorOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n156#1,11:297\n315#2,4:293\n1#3:308\n*S KotlinDebug\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering\n*L\n79#1:297,11\n66#1:293,4\n*E\n"})
public final class ES6PrimaryConstructorOptimizationLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6PrimaryConstructorOptimizationLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!(this.context.getEs6mode() && declaration instanceof IrFunction && ES6PrimaryConstructorOptimizationLoweringKt.access$getShouldBeConvertedToPlainConstructor((IrFunction)declaration))) {
            return null;
        }
        IrClass irClass = IrUtilsKt.getParentAsClass(declaration);
        IrFunction defaultConstructor = IrJsUtilsKt.findDefaultConstructorForReflection(irClass);
        if (ExportModelGeneratorKt.isExported(irClass, this.context)) {
            this.removeConstructorForExport(irClass);
        }
        IrConstructor constructorReplacement = this.convertToRegularConstructor((IrFunction)declaration, irClass);
        if (Intrinsics.areEqual(declaration, defaultConstructor)) {
            JsIrAttributesKt.setDefaultConstructorForReflection(irClass, constructorReplacement);
        }
        return kotlin.collections.CollectionsKt.listOf(constructorReplacement);
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor convertToRegularConstructor(IrFunction $this$convertToRegularConstructor, IrClass irClass) {
        IrConstructor constructor;
        IrConstructor irConstructor;
        IrValueParameterSymbol classThisSymbol;
        IrClass superClass;
        IrFunction original;
        block3: {
            List list;
            void $this$withoutFirst$iv;
            original = $this$convertToRegularConstructor;
            superClass = IrUtilsKt.getSuperClass(irClass);
            IrValueParameter irValueParameter = irClass.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter);
            classThisSymbol = irValueParameter.getSymbol();
            IrFactory $this$buildConstructor$iv = $this$convertToRegularConstructor.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$convertToRegularConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u241$iv;
            boolean $i$a$-buildConstructor-ES6PrimaryConstructorOptimizationLowering$convertToRegularConstructor$22 = false;
            ((IrFunctionBuilder)$this$convertToRegularConstructor_u24lambda_u240).updateFrom(original);
            ((IrFunctionBuilder)$this$convertToRegularConstructor_u24lambda_u240).setPrimary(true);
            ((IrFunctionBuilder)$this$convertToRegularConstructor_u24lambda_u240).setReturnType(original.getReturnType());
            ((IrDeclarationBuilder)$this$convertToRegularConstructor_u24lambda_u240).setOrigin(IrDeclarationOrigin.Companion.getDEFINED());
            constructor = irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u241$iv);
            boolean bl2 = false;
            IrUtilsKt.copyAnnotationsFrom(constructor, original);
            IrUtilsKt.copyTypeParametersFrom$default(constructor, original, null, null, 6, null);
            Map<IrTypeParameterSymbol, IrType> substitutionMap = IrUtilsKt.makeTypeParameterSubstitutionMap(original, constructor);
            IrUtilsKt.copyParameters(constructor, IrUtilsKt.getNonDispatchParameters(original), substitutionMap);
            constructor.setParent(irClass);
            if (!ExportModelGeneratorKt.isExported(irClass, this.context)) break block3;
            $this$convertToRegularConstructor_u24lambda_u240 = this;
            Iterable $i$a$-buildConstructor-ES6PrimaryConstructorOptimizationLowering$convertToRegularConstructor$22 = original.getAnnotations();
            IrConstructor irConstructor2 = constructor;
            boolean $i$f$withoutFirst = false;
            void original$iv = $this$withoutFirst$iv;
            List $this$withoutFirst_u24lambda_u240$iv = list = kotlin.collections.CollectionsKt.createListBuilder();
            boolean bl3 = false;
            boolean isFirstMatch$iv = true;
            for (Object element$iv : original$iv) {
                block5: {
                    block4: {
                        if (!isFirstMatch$iv) break block4;
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl4 = false;
                        if (IrUtilsKt.isAnnotation(it, JsAnnotations.INSTANCE.getJsExportIgnoreFqn())) break block5;
                    }
                    $this$withoutFirst_u24lambda_u240$iv.add(element$iv);
                    continue;
                }
                isFirstMatch$iv = false;
            }
            irConstructor2.setAnnotations(kotlin.collections.CollectionsKt.build(list));
        }
        IrValueParameter boxParameter = ES6AddBoxParameterLoweringKt.getBoxParameter(constructor);
        IrBody irBody = original.getBody();
        Intrinsics.checkNotNull(irBody, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        Object object = (IrBlockBody)irBody;
        IrBlockBody it = object;
        boolean bl = false;
        constructor.setBody(it);
        IrBlockBody body = object;
        object = MapsKt.emptyMap();
        IrElementTransformerVoidKt.transformChildrenVoid(body, new ValueRemapper(original, constructor, this, classThisSymbol, boxParameter, superClass, irClass, (Map<IrValueSymbol, ? extends IrValueSymbol>)object){
            private final HashMap<IrValueSymbol, IrValueSymbol> map;
            final /* synthetic */ IrFunction $original;
            final /* synthetic */ ES6PrimaryConstructorOptimizationLowering this$0;
            final /* synthetic */ IrValueParameterSymbol $classThisSymbol;
            final /* synthetic */ IrValueParameter $boxParameter;
            final /* synthetic */ IrClass $superClass;
            final /* synthetic */ IrClass $irClass;
            {
                void destination$iv;
                void $this$associateTo$iv;
                this.$original = $original;
                this.this$0 = $receiver;
                this.$classThisSymbol = $classThisSymbol;
                this.$boxParameter = $boxParameter;
                this.$superClass = $superClass;
                this.$irClass = $irClass;
                super($super_call_param$1);
                Iterable iterable = kotlin.collections.CollectionsKt.zip((Iterable)IrUtilsKt.getNonDispatchParameters($original), (Iterable)IrUtilsKt.getNonDispatchParameters($constructor));
                Map map = CollectionsKt.newHashMapWithExpectedSize($original.getParameters().size() - 1);
                convertToRegularConstructor.2.2 var17_11 = this;
                boolean $i$f$associateTo = false;
                for (T element$iv : $this$associateTo$iv) {
                    void var14_15 = destination$iv;
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    Pair<IrValueParameterSymbol, IrValueParameterSymbol> pair = TuplesKt.to(((IrValueParameter)it.getFirst()).getSymbol(), ((IrValueParameter)it.getSecond()).getSymbol());
                    var14_15.put(pair.getFirst(), pair.getSecond());
                }
                var17_11.map = (HashMap)destination$iv;
            }

            protected HashMap<IrValueSymbol, IrValueSymbol> getMap() {
                return this.map;
            }

            public IrExpression visitReturn(IrReturn expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                if (Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.$original.getSymbol())) {
                    return IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0));
                }
                return super.visitReturn(expression2);
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return Intrinsics.areEqual(expression2.getSymbol(), ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsBoxApplySymbol()) ? IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0)) : super.visitCall(expression2);
            }

            /*
             * WARNING - void declaration
             */
            public IrStatement visitVariable(IrVariable declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrExpression initializer = declaration.getInitializer();
                if (initializer instanceof IrCall) {
                    if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)initializer)) {
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        return super.visitCall((IrCall)initializer);
                    }
                    if (Intrinsics.areEqual(((IrCall)initializer).getSymbol(), ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateThisSymbol())) {
                        IrStatement irStatement;
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        if (this.$boxParameter != null && this.$superClass == null) {
                            void $this$visitVariable_u24lambda_u241;
                            IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsBoxApplySymbol(), null, null, null, null, 0, 0, 126, null);
                            IrClass irClass = this.$irClass;
                            IrValueParameter irValueParameter = this.$boxParameter;
                            IrCall irCall2 = irCall;
                            convertToRegularConstructor.2.2 var19_12 = this;
                            boolean bl = false;
                            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$visitVariable_u24lambda_u241.getArguments();
                            IrValueParameter irValueParameter2 = irClass.getThisReceiver();
                            Intrinsics.checkNotNull(irValueParameter2);
                            valueArgumentsList.set(0, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, irValueParameter2.getSymbol(), null, 2, null));
                            $this$visitVariable_u24lambda_u241.getArguments().set(1, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, irValueParameter.getSymbol(), null, 2, null));
                            irStatement = super.visitCall(irCall);
                        } else {
                            irStatement = IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0));
                        }
                        return irStatement;
                    }
                    if (Intrinsics.areEqual(((IrCall)initializer).getSymbol(), ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateExternalThisSymbol())) {
                        void $this$mapTo$iv$iv;
                        void $this$assignFrom$iv;
                        IrDelegatingConstructorCall irDelegatingConstructorCall;
                        Object object;
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        Object object2 = JsIrAttributesKt.getOriginalConstructor((IrCall)initializer);
                        if (object2 == null) {
                            IrClass irClass = this.$superClass;
                            object2 = object = irClass != null ? IrUtilsKt.getPrimaryConstructor(irClass) : null;
                        }
                        if (object2 == null || (object = ((IrConstructor)object).getSymbol()) == null) {
                            void message$iv;
                            IrExceptionBuilder irExceptionBuilder;
                            String $this$visitVariable_u24lambda_u241 = "Expect to have external constructor here";
                            IrClass bl = this.$superClass;
                            boolean $i$f$irError = false;
                            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder((String)message$iv);
                            boolean bl2 = false;
                            IrExceptionBuilder $this$visitVariable_u24lambda_u242 = $this$irError_u24lambda_u240$iv;
                            boolean bl3 = false;
                            IrClass irClass = bl;
                            if (irClass != null) {
                                IrClass it = irClass;
                                boolean bl4 = false;
                                $this$visitVariable_u24lambda_u242.withIrEntry("superClass", it);
                            }
                            IrExceptionBuilder builder$iv = irExceptionBuilder;
                            throw new IllegalStateException(builder$iv.buildString().toString());
                        }
                        Object externalConstructor = object;
                        Object message$iv = ((IrCall)initializer).getArguments().get(2);
                        IrVararg irVararg = message$iv instanceof IrVararg ? (IrVararg)message$iv : null;
                        if (irVararg == null) {
                            IrExceptionBuilder $i$f$irError;
                            message$iv = "Wrong type of argument was provided";
                            boolean $i$f$irError2 = false;
                            IrExceptionBuilder $this$irError_u24lambda_u240$iv = $i$f$irError = new IrExceptionBuilder((String)message$iv);
                            boolean bl = false;
                            IrExceptionBuilder $this$visitVariable_u24lambda_u243 = $this$irError_u24lambda_u240$iv;
                            boolean bl5 = false;
                            $this$visitVariable_u24lambda_u243.withIrEntry("initializer", initializer);
                            IrExceptionBuilder builder$iv = $i$f$irError;
                            throw new IllegalStateException(builder$iv.buildString().toString());
                        }
                        IrVararg parameters = irVararg;
                        IrDelegatingConstructorCall $this$visitVariable_u24lambda_u244 = irDelegatingConstructorCall = JsIrBuilder.buildDelegatingConstructorCall$default(JsIrBuilder.INSTANCE, (IrConstructorSymbol)externalConstructor, null, 0, 0, 14, null);
                        boolean bl = false;
                        List $i$f$irError = $this$visitVariable_u24lambda_u244.getArguments();
                        Collection other$iv = parameters.getElements();
                        boolean $i$f$assignFrom = false;
                        $this$assignFrom$iv.clear();
                        if ($this$assignFrom$iv instanceof ArrayList) {
                            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
                        }
                        Iterable $this$visitVariable_u24lambda_u243 = other$iv;
                        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            IrVarargElement builder$iv = (IrVarargElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                            collection.add((IrExpression)it);
                        }
                        return irDelegatingConstructorCall;
                    }
                }
                return super.visitVariable(declaration);
            }
        });
        return irConstructor;
    }

    private final void removeConstructorForExport(IrClass $this$removeConstructorForExport) {
        $this$removeConstructorForExport.getDeclarations().removeIf(arg_0 -> ES6PrimaryConstructorOptimizationLowering.removeConstructorForExport$lambda$1(ES6PrimaryConstructorOptimizationLowering::removeConstructorForExport$lambda$0, arg_0));
    }

    private static final boolean removeConstructorForExport$lambda$0(IrDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof IrConstructor;
    }

    private static final boolean removeConstructorForExport$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ JsIrBackendContext access$getContext$p(ES6PrimaryConstructorOptimizationLowering $this) {
        return $this.context;
    }
}

