/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOnFailureResumeOp;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;

public class MultiOnFailureTransform<T>
extends MultiOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Throwable> mapper;

    public MultiOnFailureTransform(Multi<T> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        super(upstream);
        this.predicate = predicate == null ? x -> true : predicate;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber must not be `null`");
        Function<Throwable, Flow.Publisher> next = failure -> {
            if (this.predicate.test((Throwable)failure)) {
                Throwable throwable = this.mapper.apply((Throwable)failure);
                if (throwable == null) {
                    return Multi.createFrom().failure(new NullPointerException("The mapper returned `null`"));
                }
                return Multi.createFrom().failure(throwable);
            }
            return Multi.createFrom().failure((Throwable)failure);
        };
        Multi op = Infrastructure.onMultiCreation(new MultiOnFailureResumeOp(this.upstream(), next));
        op.subscribe(subscriber);
    }
}

