/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.copy;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import liquibase.command.copy.ProjectCopier;
import liquibase.exception.UnexpectedLiquibaseException;
import org.apache.commons.io.IOUtils;

public class FileSystemProjectCopier
implements ProjectCopier {
    @Override
    public int getPriority(String path) {
        if (path == null) {
            return -1;
        }
        if (path.startsWith("/") || !path.contains(":")) {
            return 1;
        }
        if (path.startsWith("file:") || path.matches("^[A-Za-z]:.*")) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public File createWorkingStorage(String projectDir, boolean keepTempFiles) {
        File projectDirFile = new File(projectDir);
        boolean b = projectDirFile.mkdirs();
        if (!b && !projectDirFile.exists()) {
            throw new UnexpectedLiquibaseException("Unable to create project directory '" + projectDir + "'");
        }
        return projectDirFile;
    }

    @Override
    public void copy(String source, String target, boolean recursive) {
        try (InputStream input = Files.newInputStream(Paths.get(source, new String[0]), new OpenOption[0]);
             OutputStream output = Files.newOutputStream(Paths.get(target, new String[0]), new OpenOption[0]);){
            IOUtils.copyLarge((InputStream)input, (OutputStream)output);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Unable to copy file(s)! Make sure you are targeting a valid path for the new file.", e);
        }
    }
}

