/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.workflow.admin.resource;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.keycloak.models.ModelException;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.workflow.admin.resource.WorkflowStepsResource;

public class WorkflowResource {
    private final WorkflowsManager manager;
    private final Workflow workflow;

    public WorkflowResource(WorkflowsManager manager, Workflow workflow) {
        this.manager = manager;
        this.workflow = workflow;
    }

    @DELETE
    public void delete() {
        try {
            this.manager.removeWorkflow(this.workflow.getId());
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    public void update(WorkflowRepresentation rep) {
        try {
            this.manager.updateWorkflow(this.workflow, rep);
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public WorkflowRepresentation toRepresentation() {
        return this.manager.toRepresentation(this.workflow);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="bind/{type}/{resourceId}")
    public void bind(@PathParam(value="type") ResourceType type, @PathParam(value="resourceId") String resourceId, Long notBefore) {
        Object resource = this.manager.resolveResource(type, resourceId);
        if (resource == null) {
            throw new BadRequestException("Resource with id " + resourceId + " not found");
        }
        if (notBefore != null) {
            this.workflow.setNotBefore(notBefore);
        }
        this.manager.bind(this.workflow, type, resourceId);
    }

    @Path(value="steps")
    public WorkflowStepsResource steps() {
        return new WorkflowStepsResource(this.manager, this.workflow);
    }
}

