/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import jakarta.ws.rs.core.MultivaluedMap;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.ClientAuthenticationFlowContextSupplier;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.JsonWebToken;

public class ClientAssertionState {
    private static final Supplier SUPPLIER = new Supplier();
    private ClientModel client;
    private final String clientAssertionType;
    private final String clientAssertion;
    private final JWSInput jws;
    private final JsonWebToken token;

    public ClientAssertionState(ClientModel client, String clientAssertionType, String clientAssertion, JWSInput jws, JsonWebToken token) {
        this.client = client;
        this.clientAssertionType = clientAssertionType;
        this.clientAssertion = clientAssertion;
        this.jws = jws;
        this.token = token;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public String getClientAssertionType() {
        return this.clientAssertionType;
    }

    public String getClientAssertion() {
        return this.clientAssertion;
    }

    public JWSInput getJws() {
        return this.jws;
    }

    public JsonWebToken getToken() {
        return this.token;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public static ClientAuthenticationFlowContextSupplier<ClientAssertionState> supplier() {
        return SUPPLIER;
    }

    private static class Supplier
    implements ClientAuthenticationFlowContextSupplier<ClientAssertionState> {
        private Supplier() {
        }

        public ClientAssertionState get(ClientAuthenticationFlowContext context) throws JWSInputException {
            MultivaluedMap params = context.getHttpRequest().getDecodedFormParameters();
            String clientAssertionType = (String)params.getFirst((Object)"client_assertion_type");
            String clientAssertion = (String)params.getFirst((Object)"client_assertion");
            JWSInput jws = null;
            JsonWebToken token = null;
            ClientModel client = null;
            if (clientAssertion != null) {
                jws = new JWSInput(clientAssertion);
                token = (JsonWebToken)jws.readJsonContent(JsonWebToken.class);
                EventBuilder event = context.getEvent();
                event.detail("client_assertion_id", token.getId());
                event.detail("client_assertion_issuer", token.getIssuer());
                event.detail("client_assertion_sub", token.getSubject());
                if (token.getSubject() != null) {
                    client = context.getRealm().getClientByClientId(token.getSubject());
                }
            }
            return new ClientAssertionState(client, clientAssertionType, clientAssertion, jws, token);
        }
    }
}

