/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.util.ImmutableListCopy;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.ExceptionSyncInvocationStage;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class AsyncInterceptorChainImpl
implements AsyncInterceptorChain {
    private static final ImmutableListCopy<AsyncInterceptor> EMPTY_INTERCEPTORS_LIST = new ImmutableListCopy();
    private static final Log log = LogFactory.getLog(AsyncInterceptorChainImpl.class);
    private final ReentrantLock lock = new ReentrantLock();
    private volatile List<AsyncInterceptor> interceptors = EMPTY_INTERCEPTORS_LIST;
    private volatile AsyncInterceptor firstInterceptor = null;

    @Start
    void printChainInfo() {
        if (log.isDebugEnabled()) {
            log.debugf("Interceptor chain size: %d", this.size());
            log.debugf("Interceptor chain is: %s", this.toString());
        }
    }

    private void validateCustomInterceptor(Class<? extends AsyncInterceptor> i) {
    }

    private void checkInterceptor(Class<? extends AsyncInterceptor> clazz) {
        if (this.containsInterceptorType(clazz, false)) {
            throw new CacheConfigurationException("Detected interceptor of type [" + clazz.getName() + "] being added to the interceptor chain " + System.identityHashCode(this) + " more than once!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterceptor(AsyncInterceptor interceptor, int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = interceptor.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)position, (Object)interceptor);
            this.rebuildInterceptors();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeInterceptor(int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.interceptors = Immutables.immutableListRemove(this.interceptors, (int)position);
            this.rebuildInterceptors();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.interceptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(Class<? extends AsyncInterceptor> clazz) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), clazz)) continue;
                this.removeInterceptor(i);
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    private boolean interceptorMatches(AsyncInterceptor interceptor, Class<? extends AsyncInterceptor> clazz) {
        Class<?> interceptorType = interceptor.getClass();
        return clazz == interceptorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInterceptorAfter(AsyncInterceptor toAdd, Class<? extends AsyncInterceptor> afterInterceptor) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), afterInterceptor)) continue;
                this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)(i + 1), (Object)toAdd);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInterceptorBefore(AsyncInterceptor toAdd, Class<? extends AsyncInterceptor> beforeInterceptor) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), beforeInterceptor)) continue;
                this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)i, (Object)toAdd);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceInterceptor(AsyncInterceptor replacingInterceptor, Class<? extends AsyncInterceptor> existingInterceptorType) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = replacingInterceptor.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), existingInterceptorType)) continue;
                this.interceptors = Immutables.immutableListReplace(this.interceptors, (int)i, (Object)replacingInterceptor);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendInterceptor(AsyncInterceptor ci, boolean isCustom) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = ci.getClass();
            if (isCustom) {
                this.validateCustomInterceptor(interceptorClass);
            }
            this.checkInterceptor(interceptorClass);
            this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)this.interceptors.size(), (Object)ci);
            this.rebuildInterceptors();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CompletableFuture<Object> invokeAsync(InvocationContext ctx, VisitableCommand command) {
        try {
            Object result = this.firstInterceptor.visitCommand(ctx, command);
            if (result instanceof InvocationStage) {
                return ((InvocationStage)result).toCompletableFuture();
            }
            if (result == null) {
                return CompletableFutures.completedNull();
            }
            return CompletableFuture.completedFuture(result);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public InvocationStage invokeStage(InvocationContext ctx, VisitableCommand command) {
        try {
            return InvocationStage.makeStage(this.firstInterceptor.visitCommand(ctx, command));
        }
        catch (Throwable t) {
            return new ExceptionSyncInvocationStage(t);
        }
    }

    @Override
    public Object invoke(InvocationContext ctx, VisitableCommand command) {
        try {
            Object result = this.firstInterceptor.visitCommand(ctx, command);
            if (result instanceof InvocationStage) {
                return ((InvocationStage)result).get();
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new TimeoutException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CacheException(throwable);
        }
    }

    @Override
    public <T extends AsyncInterceptor> T findInterceptorExtending(Class<T> interceptorClass) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            boolean isSubclass = interceptorClass.isInstance(interceptor);
            if (!isSubclass) continue;
            return (T)((AsyncInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    @Override
    public <T extends AsyncInterceptor> T findInterceptorWithClass(Class<T> interceptorClass) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            if (!this.interceptorMatches(interceptor, interceptorClass)) continue;
            return (T)((AsyncInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            sb.append("\n\t>> ");
            sb.append(interceptor);
        }
        return sb.toString();
    }

    @Override
    public boolean containsInstance(AsyncInterceptor interceptor) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor current : localInterceptors) {
            if (current != interceptor) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInterceptorType(Class<? extends AsyncInterceptor> interceptorType) {
        return this.containsInterceptorType(interceptorType, false);
    }

    @Override
    public boolean containsInterceptorType(Class<? extends AsyncInterceptor> interceptorType, boolean alsoMatchSubClasses) {
        List<AsyncInterceptor> localInterceptors = this.interceptors;
        for (AsyncInterceptor interceptor : localInterceptors) {
            Class<?> currentInterceptorType = interceptor.getClass();
            if (!(alsoMatchSubClasses ? interceptorType.isAssignableFrom(currentInterceptorType) : interceptorType == currentInterceptorType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AsyncInterceptor> getInterceptors() {
        return this.interceptors;
    }

    private void rebuildInterceptors() {
        ListIterator<AsyncInterceptor> it = this.interceptors.listIterator(this.interceptors.size());
        AsyncInterceptor nextInterceptor = it.previous();
        while (it.hasPrevious()) {
            AsyncInterceptor interceptor = it.previous();
            interceptor.setNextInterceptor(nextInterceptor);
            nextInterceptor = interceptor;
        }
        this.firstInterceptor = nextInterceptor;
    }
}

