/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.MariaDBLegacySqlAstTranslator;
import org.hibernate.community.dialect.MySQLLegacyDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MySQLServerConfiguration;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.dialect.aggregate.MySQLAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.lock.internal.MariaDBLockingSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.sequence.MariaDBSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.type.MariaDBCastingJsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.MariaDBCastingJsonJdbcType;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorMariaDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.VarcharUUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class MariaDBLegacyDialect
extends MySQLLegacyDialect {
    private static final DatabaseVersion VERSION5 = DatabaseVersion.make((Integer)5);
    private static final DatabaseVersion VERSION57 = DatabaseVersion.make((Integer)5, (Integer)7);

    public MariaDBLegacyDialect() {
        this(DatabaseVersion.make((Integer)5));
    }

    public MariaDBLegacyDialect(DatabaseVersion version) {
        super(version);
    }

    public MariaDBLegacyDialect(DialectResolutionInfo info) {
        super(MariaDBLegacyDialect.createVersion(info), MySQLServerConfiguration.fromDialectResolutionInfo((DialectResolutionInfo)info));
        this.registerKeywords(info);
    }

    @Override
    protected LockingSupport buildLockingSupport() {
        return new MariaDBLockingSupport(this.getVersion());
    }

    @Override
    public DatabaseVersion getMySQLVersion() {
        return this.getVersion().isBefore(5, 3) ? VERSION5 : VERSION57;
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        if (this.getVersion().isSameOrAfter(10, 2)) {
            CommonFunctionFactory commonFunctionFactory = new CommonFunctionFactory(functionContributions);
            commonFunctionFactory.windowFunctions();
            commonFunctionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
            functionContributions.getFunctionRegistry().registerNamed("json_valid", functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN));
            commonFunctionFactory.jsonValue_mariadb();
            commonFunctionFactory.jsonArray_mariadb();
            commonFunctionFactory.jsonQuery_mariadb();
            commonFunctionFactory.jsonArrayAgg_mariadb();
            commonFunctionFactory.jsonObjectAgg_mariadb();
            commonFunctionFactory.jsonArrayAppend_mariadb();
            if (this.getVersion().isSameOrAfter(10, 3, 3)) {
                if (this.getVersion().isSameOrAfter(10, 6)) {
                    commonFunctionFactory.unnest_emulated();
                    commonFunctionFactory.jsonTable_mysql();
                }
                commonFunctionFactory.inverseDistributionOrderedSetAggregates_windowEmulation();
                functionContributions.getFunctionRegistry().patternDescriptorBuilder("median", "median(?1) over ()").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
            }
        }
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isSameOrAfter(10, 7)) {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3000, "uuid", (Dialect)this));
        }
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return this.getVersion().isSameOrAfter(10, 2) ? MySQLAggregateSupport.forMariaDB((Dialect)this) : AggregateSupportImpl.INSTANCE;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uuid": {
                        jdbcTypeCode = 3000;
                    }
                }
                break;
            }
            case -3: {
                if (!"GEOMETRY".equals(columnTypeName)) break;
                jdbcTypeCode = 3200;
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptorIfAbsent(3001, (JdbcType)MariaDBCastingJsonJdbcType.INSTANCE);
        jdbcTypeRegistry.addTypeConstructorIfAbsent((JdbcTypeConstructor)MariaDBCastingJsonArrayJdbcTypeConstructor.INSTANCE);
        super.contributeTypes(typeContributions, serviceRegistry);
        if (this.getVersion().isSameOrAfter(10, 7)) {
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)VarcharUUIDJdbcType.INSTANCE);
        }
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        return to == CastType.JSON ? "json_extract(?1,'$')" : super.castPattern(from, to);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MariaDBLegacySqlAstTranslator(sessionFactory, statement, MariaDBLegacyDialect.this);
            }
        };
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(10, 2);
    }

    @Override
    public boolean supportsLateral() {
        return false;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(10, 2);
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.getVersion().isSameOrAfter(10, 2);
    }

    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    @Override
    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return InnoDBStorageEngine.INSTANCE;
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion().isSameOrAfter(10);
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return this.getVersion().isSameOrAfter(10, 5);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isBefore(10, 3) ? super.getSequenceSupport() : MariaDBSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return this.getSequenceSupport().supportsSequences() ? "select table_name from information_schema.TABLES where table_schema=database() and table_type='SEQUENCE'" : super.getQuerySequencesString();
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getSequenceSupport().supportsSequences() ? SequenceInformationExtractorMariaDBDatabaseImpl.INSTANCE : super.getSequenceInformationExtractor();
    }

    @Override
    boolean supportsForShare() {
        return false;
    }

    @Override
    boolean supportsAliasLocks() {
        return false;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_GROUP_AND_CONSTANTS;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData metadata) throws SQLException {
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        return super.buildIdentifierHelper(builder, metadata);
    }

    @Override
    public String getDual() {
        return "dual";
    }

    @Override
    public String getFromDualForSelectOnly() {
        return this.getVersion().isBefore(10, 4) ? " from " + this.getDual() : "";
    }

    @Override
    public boolean supportsIntersect() {
        return this.getVersion().isSameOrAfter(10, 3);
    }

    @Override
    public boolean supportsSimpleQueryGrouping() {
        return this.getVersion().isSameOrAfter(10, 4);
    }

    @Override
    public boolean supportsWithClause() {
        return this.getVersion().isSameOrAfter(10, 2);
    }

    public boolean supportsWithClauseInSubquery() {
        return false;
    }
}

