/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jts;

import com.arjuna.ats.arjuna.utils.ThreadUtil;
import com.arjuna.ats.internal.jbossatx.jts.PropagationContextWrapper;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jts.ExplicitInterposition;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.omg.CosTransactions.PropagationContext;

public class PropagationContextManager
implements TransactionPropagationContextFactory,
TransactionPropagationContextImporter,
ObjectFactory,
Serializable {
    private static final long serialVersionUID = 1L;

    public Object getTransactionPropagationContext() {
        String threadId;
        if (jbossatxLogger.logger.isTraceEnabled()) {
            jbossatxLogger.logger.trace((Object)"PropagationContextManager.getTransactionPropagationContext - called");
        }
        ControlWrapper theControl = (threadId = ThreadUtil.getThreadId()) != null ? OTSImpleManager.current().contextManager().current(threadId) : OTSImpleManager.current().contextManager().current();
        try {
            PropagationContext cxt = theControl.get_coordinator().get_txcontext();
            PropagationContextWrapper pcw = new PropagationContextWrapper(cxt);
            if (jbossatxLogger.logger.isTraceEnabled()) {
                jbossatxLogger.logger.trace((Object)("PropagationContextManager.getTransactionPropagationContext() - returned tpc = " + String.valueOf(pcw)));
            }
            return pcw;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getTransactionPropagationContext(Transaction tx) {
        if (jbossatxLogger.logger.isTraceEnabled()) {
            jbossatxLogger.logger.trace((Object)("PropagationContextManager.getTransactionPropagationContext(Transaction) - called tx = " + String.valueOf(tx)));
        }
        Transaction oldTx = null;
        Object tpc = null;
        jakarta.transaction.TransactionManager tm = TransactionManager.transactionManager();
        try {
            oldTx = tm.getTransaction();
            if (tx == null || tx.equals(oldTx)) {
                tpc = this.getTransactionPropagationContext();
            } else {
                tm.suspend();
                tm.resume(tx);
                tpc = this.getTransactionPropagationContext();
                tm.suspend();
                tm.resume(oldTx);
            }
        }
        catch (Exception e) {
            jbossatxLogger.i18NLogger.error_jta_PropagationContextManager_exception(e);
        }
        if (jbossatxLogger.logger.isTraceEnabled()) {
            jbossatxLogger.logger.trace((Object)("PropagationContextManager.getTransactionPropagationContext(Transaction) - returned tpc = " + String.valueOf(tpc)));
        }
        return tpc;
    }

    public Transaction importTransactionPropagationContext(Object tpc) {
        if (jbossatxLogger.logger.isTraceEnabled()) {
            jbossatxLogger.logger.trace((Object)("PropagationContextManager.importTransactionPropagationContext(Object) - called tpc = " + String.valueOf(tpc)));
        }
        jakarta.transaction.TransactionManager tm = TransactionManager.transactionManager();
        if (tpc instanceof PropagationContextWrapper) {
            try {
                PropagationContext omgTpc = ((PropagationContextWrapper)tpc).getPropagationContext();
                ExplicitInterposition ei = new ExplicitInterposition(omgTpc, true);
                Transaction newTx = tm.getTransaction();
                if (jbossatxLogger.logger.isTraceEnabled()) {
                    jbossatxLogger.logger.trace((Object)("PropagationContextManager.importTransactionPropagationContext(Object) - transaction = " + String.valueOf(newTx)));
                }
                ei.unregisterTransaction();
                return newTx;
            }
            catch (Exception e) {
                jbossatxLogger.i18NLogger.error_jts_PropagationContextManager_exception(e);
                return null;
            }
        }
        jbossatxLogger.i18NLogger.error_jts_PropagationContextManager_unknownctx();
        return null;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return new PropagationContextManager();
    }
}

