/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.mutiny.core.http.HttpClient;
import io.vertx.mutiny.core.http.HttpClientResponse;
import io.vertx.mutiny.core.http.HttpConnection;
import java.util.function.Consumer;
import java.util.function.Function;

@MutinyGen(value=io.vertx.core.http.HttpClientBuilder.class)
public class HttpClientBuilder
implements MutinyDelegate {
    public static final TypeArg<HttpClientBuilder> __TYPE_ARG = new TypeArg(obj -> new HttpClientBuilder((io.vertx.core.http.HttpClientBuilder)obj), HttpClientBuilder::getDelegate);
    private final io.vertx.core.http.HttpClientBuilder delegate;

    public HttpClientBuilder(io.vertx.core.http.HttpClientBuilder delegate) {
        this.delegate = delegate;
    }

    public HttpClientBuilder(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientBuilder)delegate;
    }

    HttpClientBuilder() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpClientBuilder getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientBuilder that = (HttpClientBuilder)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Fluent
    public HttpClientBuilder with(HttpClientOptions options) {
        this.delegate.with(options);
        return this;
    }

    @Fluent
    public HttpClientBuilder with(PoolOptions options) {
        this.delegate.with(options);
        return this;
    }

    @Fluent
    private HttpClientBuilder __withConnectHandler(Handler<HttpConnection> handler) {
        this.delegate.withConnectHandler(MutinyHelper.convertHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    public HttpClientBuilder withConnectHandler(Consumer<HttpConnection> handler) {
        return this.__withConnectHandler((Handler<HttpConnection>)MutinyHelper.convertConsumer(handler));
    }

    @Fluent
    public HttpClientBuilder withRedirectHandler(final Function<HttpClientResponse, Uni<RequestOptions>> handler) {
        this.delegate.withRedirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, Future<RequestOptions>>(){

            @Override
            public Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                return UniHelper.toFuture((Uni)((Uni)handler.apply(HttpClientResponse.newInstance(arg))));
            }
        });
        return this;
    }

    public HttpClient build() {
        HttpClient ret = HttpClient.newInstance(this.delegate.build());
        return ret;
    }

    public static HttpClientBuilder newInstance(io.vertx.core.http.HttpClientBuilder arg) {
        return arg != null ? new HttpClientBuilder(arg) : null;
    }
}

