/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.StoreManagers;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.TxAwareLDAPUserModelDelegate;

public class UserAttributeLDAPStorageMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(UserAttributeLDAPStorageMapper.class);
    private static final Map<String, Property<Object>> userModelProperties = LDAPUtils.getUserModelProperties();
    public static final String USER_MODEL_ATTRIBUTE = "user.model.attribute";
    public static final String LDAP_ATTRIBUTE = "ldap.attribute";
    public static final String READ_ONLY = "read.only";
    public static final String ALWAYS_READ_VALUE_FROM_LDAP = "always.read.value.from.ldap";
    public static final String IS_MANDATORY_IN_LDAP = "is.mandatory.in.ldap";
    public static final String IS_BINARY_ATTRIBUTE = "is.binary.attribute";
    public static final String ATTRIBUTE_DEFAULT_VALUE = "attribute.default.value";
    public static final String FORCE_DEFAULT_VALUE = "attribute.force.default";

    public UserAttributeLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        if (this.isBinaryAttribute()) {
            return;
        }
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            String ldapAttrValue = ldapUser.getAttributeAsString(ldapAttrName);
            this.checkDuplicateEmail(userModelAttrName, ldapAttrValue, realm, this.ldapProvider.getSession(), user);
            this.setPropertyOnUserModel(userModelProperty, user, ldapAttrValue);
        } else {
            Set<String> ldapAttrValue = ldapUser.getAttributeAsSet(ldapAttrName);
            if (ldapAttrValue != null) {
                user.setAttribute(userModelAttrName, new ArrayList<String>(ldapAttrValue));
            } else {
                user.removeAttribute(userModelAttrName);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        boolean isMandatoryInLdap = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, IS_MANDATORY_IN_LDAP);
        String attributeDefaultValue = this.getAttributeDefaultValue();
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            Object attrValue = userModelProperty.getValue((Object)localUser);
            if (attrValue == null) {
                if (isMandatoryInLdap && attributeDefaultValue != null) {
                    ldapUser.setSingleAttribute(ldapAttrName, attributeDefaultValue);
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                }
            } else {
                ldapUser.setSingleAttribute(ldapAttrName, attrValue.toString());
            }
        } else {
            List attrValues = localUser.getAttributeStream(userModelAttrName).collect(Collectors.toList());
            if (attrValues.isEmpty()) {
                if (isMandatoryInLdap && attributeDefaultValue != null) {
                    ldapUser.setSingleAttribute(ldapAttrName, attributeDefaultValue);
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                }
            } else {
                ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>(attrValues));
            }
        }
        if (this.isReadOnly()) {
            ldapUser.addReadOnlyAttributeName(ldapAttrName);
        }
    }

    @Override
    public Set<String> mandatoryAttributeNames() {
        boolean isMandatoryInLdap = this.mapperModel.get(IS_MANDATORY_IN_LDAP, false);
        return isMandatoryInLdap ? Collections.singleton(this.getLdapAttributeName()) : null;
    }

    @Override
    public Set<String> getUserAttributes() {
        return Collections.singleton(this.getUserModelAttribute());
    }

    protected void checkDuplicateEmail(String userModelAttrName, String email, RealmModel realm, KeycloakSession session, UserModel user) {
        if (email == null || realm.isDuplicateEmailsAllowed()) {
            return;
        }
        if ("email".equalsIgnoreCase(userModelAttrName)) {
            email = KeycloakModelUtils.toLowerCaseSafe((String)email);
            UserModel that = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).getUserByEmail(realm, email);
            if (that != null && !that.getId().equals(user.getId()) && (that = ((StoreManagers)session.getProvider(DatastoreProvider.class)).userStorageManager().getUserById(realm, that.getId())) != null) {
                session.getTransactionManager().setRollbackOnly();
                String exceptionMessage = String.format("Can't import user '%s' from LDAP because email '%s' already exists in Keycloak. Existing user with this email is '%s'", user.getUsername(), email, that.getUsername());
                throw new ModelDuplicateException(exceptionMessage, "email");
            }
        }
    }

    protected void checkDuplicateUsername(String userModelAttrName, String username, RealmModel realm, KeycloakSession session, UserModel user) {
        if ("username".equalsIgnoreCase(userModelAttrName)) {
            boolean usernameChanged;
            if (username == null || username.isEmpty()) {
                throw new ModelException("Cannot set an empty username");
            }
            boolean bl = usernameChanged = !username.equals(user.getUsername());
            if (realm.isEditUsernameAllowed() && usernameChanged) {
                UserModel that = session.users().getUserByUsername(realm, username);
                if (that != null && !that.getId().equals(user.getId())) {
                    throw new ModelDuplicateException(String.format("Cannot change the username to '%s' because the username already exists in keycloak", username), "username");
                }
            } else if (usernameChanged) {
                if (realm.isRegistrationEmailAsUsername() && username.equals(user.getEmail())) {
                    return;
                }
                throw new ModelException("Cannot change username if the realm is not configured to allow edit the usernames");
            }
        }
    }

    @Override
    public UserModel proxy(final LDAPObject ldapUser, UserModel delegate, final RealmModel realm) {
        final String userModelAttrName = this.getUserModelAttribute();
        final String ldapAttrName = this.getLdapAttributeName();
        boolean isAlwaysReadValueFromLDAP = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, ALWAYS_READ_VALUE_FROM_LDAP);
        final boolean isMandatoryInLdap = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, IS_MANDATORY_IN_LDAP);
        final boolean isBinaryAttribute = UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, IS_BINARY_ATTRIBUTE);
        final String attributeDefaultValue = this.getAttributeDefaultValue();
        if (this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && !this.isReadOnly()) {
            delegate = new TxAwareLDAPUserModelDelegate((UserModel)delegate, this.ldapProvider, ldapUser){

                public void setSingleAttribute(String name, String value) {
                    if ("username".equals(name)) {
                        this.setUsername(value);
                    } else if ("email".equals(name)) {
                        this.setEmail(value);
                    } else if (this.setLDAPAttribute(name, value)) {
                        super.setSingleAttribute(name, value);
                    }
                }

                public void setAttribute(String name, List<String> values) {
                    if ("username".equals(name)) {
                        this.setUsername(values != null && values.size() > 0 ? values.get(0) : null);
                    } else if ("email".equals(name)) {
                        this.setEmail(values != null && values.size() > 0 ? values.get(0) : null);
                    } else if (this.setLDAPAttribute(name, values)) {
                        super.setAttribute(name, values);
                    }
                }

                public void removeAttribute(String name) {
                    if (!"username".equals(name) && this.setLDAPAttribute(name, null)) {
                        super.removeAttribute(name);
                    }
                }

                public void setUsername(String username) {
                    String lowercaseUsername = KeycloakModelUtils.toLowerCaseSafe((String)username);
                    UserAttributeLDAPStorageMapper.this.checkDuplicateUsername(userModelAttrName, lowercaseUsername, realm, UserAttributeLDAPStorageMapper.this.ldapProvider.getSession(), (UserModel)this);
                    this.setLDAPAttribute("username", lowercaseUsername);
                    super.setUsername(lowercaseUsername);
                }

                public void setEmail(String email) {
                    String lowercaseEmail = KeycloakModelUtils.toLowerCaseSafe((String)email);
                    UserAttributeLDAPStorageMapper.this.checkDuplicateEmail(userModelAttrName, email, realm, UserAttributeLDAPStorageMapper.this.ldapProvider.getSession(), (UserModel)this);
                    this.setLDAPAttribute("email", email);
                    super.setEmail(lowercaseEmail);
                }

                public void setEnabled(boolean enabled) {
                    this.setLDAPAttribute("enabled", Boolean.toString(enabled));
                    super.setEnabled(enabled);
                }

                public void setLastName(String lastName) {
                    this.setLDAPAttribute("lastName", lastName);
                    super.setLastName(lastName);
                }

                public void setFirstName(String firstName) {
                    this.setLDAPAttribute("firstName", firstName);
                    super.setFirstName(firstName);
                }

                public void setEmailVerified(boolean verified) {
                    this.setLDAPAttribute("emailVerified", Boolean.toString(verified));
                    super.setEmailVerified(verified);
                }

                public String getUsername() {
                    if ("username".equals(userModelAttrName)) {
                        return Optional.ofNullable(this.ldapUser.getAttributeAsString(ldapAttrName)).map(String::toLowerCase).orElse(null);
                    }
                    return super.getUsername();
                }

                public String getEmail() {
                    if ("email".equals(userModelAttrName)) {
                        return Optional.ofNullable(this.ldapUser.getAttributeAsString(ldapAttrName)).map(String::toLowerCase).orElse(null);
                    }
                    return super.getEmail();
                }

                protected boolean setLDAPAttribute(String modelAttrName, Object value) {
                    if (modelAttrName.equalsIgnoreCase(userModelAttrName)) {
                        if (logger.isTraceEnabled()) {
                            logger.tracef("Pushing user attribute to LDAP. username: %s, Model attribute name: %s, LDAP attribute name: %s, Attribute value: %s", new Object[]{this.getUsername(), modelAttrName, ldapAttrName, value});
                        }
                        this.markUpdatedAttributeInTransaction(modelAttrName);
                        if (value == null) {
                            if (isMandatoryInLdap && attributeDefaultValue != null) {
                                this.ldapUser.setSingleAttribute(ldapAttrName, attributeDefaultValue);
                            } else {
                                this.ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                            }
                        } else if (value instanceof String) {
                            this.ldapUser.setSingleAttribute(ldapAttrName, (String)value);
                        } else {
                            List asList = (List)value;
                            if (asList.isEmpty() && isMandatoryInLdap && attributeDefaultValue != null) {
                                this.ldapUser.setSingleAttribute(ldapAttrName, attributeDefaultValue);
                            } else {
                                this.ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>(asList));
                            }
                        }
                        if (isBinaryAttribute) {
                            logger.debugf("Skip writing model attribute '%s' to DB for user '%s' as it is mapped to binary LDAP attribute.", (Object)userModelAttrName, (Object)this.getUsername());
                            return false;
                        }
                        return true;
                    }
                    return true;
                }
            };
        } else if (isBinaryAttribute) {
            delegate = new UserModelDelegate((UserModel)delegate){

                public void setSingleAttribute(String name, String value) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        this.logSkipDBWrite();
                    } else {
                        super.setSingleAttribute(name, value);
                    }
                }

                public void setAttribute(String name, List<String> values) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        this.logSkipDBWrite();
                    } else {
                        super.setAttribute(name, values);
                    }
                }

                public void removeAttribute(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        this.logSkipDBWrite();
                    } else {
                        super.removeAttribute(name);
                    }
                }

                private void logSkipDBWrite() {
                    logger.debugf("Skip writing model attribute '%s' to DB for user '%s' as it is mapped to binary LDAP attribute", (Object)userModelAttrName, (Object)this.getUsername());
                }
            };
        }
        if (isAlwaysReadValueFromLDAP) {
            delegate = new UserModelDelegate((UserModel)delegate){

                public String getFirstAttribute(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getFirstAttribute(name);
                }

                public Stream<String> getAttributeStream(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        Set<String> ldapAttrValue = ldapUser.getAttributeAsSet(ldapAttrName);
                        if (ldapAttrValue == null) {
                            return Stream.empty();
                        }
                        return ldapAttrValue.stream();
                    }
                    return super.getAttributeStream(name);
                }

                public Map<String, List<String>> getAttributes() {
                    HashMap<String, List<String>> attrs = new HashMap<String, List<String>>(super.getAttributes());
                    Set<String> allLdapAttrValues = ldapUser.getAttributeAsSet(ldapAttrName);
                    if (allLdapAttrValues != null) {
                        attrs.put(userModelAttrName, new ArrayList<String>(allLdapAttrValues));
                    } else {
                        attrs.remove(userModelAttrName);
                    }
                    return attrs;
                }

                public String getEmail() {
                    if ("email".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getEmail();
                }

                public boolean isEnabled() {
                    if ("enabled".equalsIgnoreCase(userModelAttrName)) {
                        return Boolean.parseBoolean(ldapUser.getAttributeAsString(ldapAttrName));
                    }
                    return super.isEnabled();
                }

                public boolean isEmailVerified() {
                    if ("emailVerified".equalsIgnoreCase(userModelAttrName)) {
                        return Boolean.parseBoolean(ldapUser.getAttributeAsString(ldapAttrName));
                    }
                    return super.isEmailVerified();
                }

                public String getLastName() {
                    if ("lastName".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getLastName();
                }

                public String getFirstName() {
                    if ("firstName".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getFirstName();
                }
            };
        }
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String userModelAttrName = this.getUserModelAttribute();
        String ldapAttrName = this.getLdapAttributeName();
        query.addReturningLdapAttribute(ldapAttrName);
        if (this.isReadOnly()) {
            query.addReturningReadOnlyLdapAttribute(ldapAttrName);
        }
        for (Condition condition : query.getConditions()) {
            condition.updateParameterName(userModelAttrName, ldapAttrName);
            String parameterName = condition.getParameterName();
            if (parameterName == null || !parameterName.equalsIgnoreCase(userModelAttrName) && !parameterName.equalsIgnoreCase(ldapAttrName)) continue;
            condition.setBinary(this.isBinaryAttribute());
        }
    }

    private String getAttributeDefaultValue() {
        String attributeDefaultValue = (String)this.mapperModel.getConfig().getFirst((Object)ATTRIBUTE_DEFAULT_VALUE);
        attributeDefaultValue = attributeDefaultValue == null || attributeDefaultValue.trim().isEmpty() ? null : attributeDefaultValue;
        boolean forceDefault = this.mapperModel.get(FORCE_DEFAULT_VALUE, true);
        return forceDefault && attributeDefaultValue == null ? " " : attributeDefaultValue;
    }

    private String getUserModelAttribute() {
        return (String)this.mapperModel.getConfig().getFirst((Object)USER_MODEL_ATTRIBUTE);
    }

    String getLdapAttributeName() {
        return (String)this.mapperModel.getConfig().getFirst((Object)LDAP_ATTRIBUTE);
    }

    private boolean isBinaryAttribute() {
        return this.mapperModel.get(IS_BINARY_ATTRIBUTE, false);
    }

    private boolean isReadOnly() {
        return UserAttributeLDAPStorageMapper.parseBooleanParameter(this.mapperModel, READ_ONLY);
    }

    protected void setPropertyOnUserModel(Property<Object> userModelProperty, UserModel user, String ldapAttrValue) {
        if (ldapAttrValue == null) {
            userModelProperty.setValue((Object)user, null);
        } else {
            Class clazz = userModelProperty.getJavaClass();
            Object currentValue = userModelProperty.getValue((Object)user);
            if (String.class.equals((Object)clazz)) {
                if (ldapAttrValue.equals(currentValue)) {
                    return;
                }
                userModelProperty.setValue((Object)user, (Object)ldapAttrValue);
            } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
                Boolean boolVal = Boolean.valueOf(ldapAttrValue);
                if (boolVal.equals(currentValue)) {
                    return;
                }
                userModelProperty.setValue((Object)user, (Object)boolVal);
            } else {
                logger.warnf("Don't know how to set the property '%s' on user '%s' . Value of LDAP attribute is '%s' ", (Object)userModelProperty.getName(), (Object)user.getUsername(), (Object)ldapAttrValue.toString());
            }
        }
    }
}

