/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ForwardedInfo;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

final class LocationUtil {
    LocationUtil() {
    }

    static URI determineLocation(URI location) {
        ResteasyReactiveRequestContext request;
        if (!location.isAbsolute() && (request = CurrentRequestManager.get()) != null) {
            ServerHttpRequest req = request.serverRequest();
            try {
                String host = req.getRequestHost();
                int port = -1;
                int index = host.lastIndexOf(":");
                if (index > -1 && (host.charAt(0) != '[' || index > host.lastIndexOf("]"))) {
                    port = Integer.parseInt(host.substring(index + 1));
                    host = host.substring(0, index);
                }
                String prefix = LocationUtil.determinePrefix(req, request.getDeployment());
                Object path = location.toString();
                if (!((String)path).startsWith("/")) {
                    path = "/" + (String)path;
                }
                URI baseUri = new URI(req.getRequestScheme(), null, host, port, null, null, null);
                location = baseUri.resolve(prefix + (String)path);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return location;
    }

    private static String determinePrefix(ServerHttpRequest serverHttpRequest, Deployment deployment) {
        ForwardedInfo forwardedInfo;
        Object prefix = "";
        if (deployment != null) {
            prefix = deployment.getPrefix();
        }
        if ((forwardedInfo = serverHttpRequest.getForwardedInfo()) != null && forwardedInfo.getPrefix() != null && !forwardedInfo.getPrefix().isEmpty()) {
            Object forwardedPrefix = forwardedInfo.getPrefix();
            if (!((String)forwardedPrefix).startsWith("/")) {
                forwardedPrefix = "/" + (String)forwardedPrefix;
            }
            prefix = (String)forwardedPrefix + (String)prefix;
        }
        if (((String)prefix).endsWith("/")) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1);
        }
        return prefix;
    }

    static URI determineContentLocation(URI location) {
        ResteasyReactiveRequestContext request;
        if (!location.isAbsolute() && (request = CurrentRequestManager.get()) != null) {
            ServerHttpRequest req = request.serverRequest();
            try {
                Object path;
                String host = req.getRequestHost();
                int port = -1;
                int index = host.lastIndexOf(":");
                if (index > -1 && (host.charAt(0) != '[' || index > host.lastIndexOf("]"))) {
                    port = Integer.parseInt(host.substring(index + 1));
                    host = host.substring(0, index);
                }
                if (!((String)(path = location.toString())).startsWith("/")) {
                    path = "/" + (String)path;
                }
                location = new URI(req.getRequestScheme(), null, host, port, null, null, null).resolve((String)path);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return location;
    }
}

