/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sf.juife.Task;

public class TaskList {
    private final String name;
    private final Vector<Task> taskList = new Vector();
    private boolean started = false;
    private boolean processed = false;
    private static int serial = 0;
    protected final EventListenerList listenerList = new EventListenerList();

    public TaskList() {
        this("TaskList-" + TaskList.getSerialNumber());
    }

    public TaskList(String name) {
        this(name, (Task[])null);
    }

    public TaskList(Task ... tasks) {
        this("TaskList-" + TaskList.getSerialNumber(), tasks);
    }

    public TaskList(String name, Task ... tasks) {
        this.name = name;
        if (tasks == null) {
            return;
        }
        for (Task t : tasks) {
            this.add(t);
        }
    }

    public void add(Task task) {
        if (this.isStarted()) {
            throw new IllegalStateException("The TaskList is already started");
        }
        this.taskList.add(task);
    }

    public void process() {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        new Thread(this.name){

            @Override
            public void run() {
                for (Task t : TaskList.this.taskList) {
                    t.invokeAndWait();
                }
                TaskList.this.fireActionPerformed();
                TaskList.this.processed = true;
            }
        }.start();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    private static synchronized int getSerialNumber() {
        return ++serial;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireActionPerformed() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TaskList.this.fireActionPerformed0();
                }
            });
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void fireActionPerformed0() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = new ActionEvent(this, 1001, "finish");
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }
}

