/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.AbstractValueList;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.IdentValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSColor;
import org.w3c.css.om.typed.CSSStyleValueList;
import org.w3c.dom.DOMException;

public class ColorFunction
extends ColorValue
implements CSSColor {
    private static final long serialVersionUID = 1L;
    private IdentValue colorSpace;
    private AbstractValueList<NumericValue> channels;
    private static final Set<String> predefinedSpaces = new HashSet<String>(9);

    public ColorFunction(String colorSpace, CSSStyleValueList<NumericValue> channels) throws DOMSyntaxException {
        this.colorSpace = new IdentValue(ColorFunction.canonicalName(colorSpace));
        this.componentize(this.colorSpace);
        this.componentizeChannels(channels);
    }

    private void componentizeChannels(CSSStyleValueList<NumericValue> channels) {
        boolean clone = channels instanceof AbstractValue && ((AbstractValue)channels).handler != null;
        int len = channels.getLength();
        this.channels = new AbstractValueList(' ', len);
        for (NumericValue channel : channels) {
            if (clone) {
                channel = channel.clone();
            }
            this.channels.add(this.numericComponent(channel));
        }
        this.componentize(this.channels);
    }

    public IdentValue getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public String getCSSColorSpace() {
        return this.colorSpace.getValue();
    }

    public void setColorSpace(String cs) {
        this.colorSpace.setValue(ColorFunction.canonicalName(cs));
        this.componentChanged(this.colorSpace);
    }

    static String canonicalName(String cs) throws DOMException {
        if (!predefinedSpaces.contains(cs = cs.toLowerCase(Locale.ROOT).intern())) {
            throw new DOMException(9, "Unsupported color space: " + cs);
        }
        return cs;
    }

    public CSSStyleValueList<NumericValue> getChannels() {
        return this.channels;
    }

    @Override
    public int getLength() throws DOMException {
        return this.channels.getLength() + 2;
    }

    @Override
    public Value item(int index) throws DOMException {
        if (index == 0) {
            return this.getColorSpace();
        }
        if (index == this.channels.getLength() + 1) {
            return this.getAlpha();
        }
        return this.channels.item(index - 1);
    }

    @Override
    public ColorFunction getColorValue() {
        return this;
    }

    public String getCssText() {
        StringBuilder buf = new StringBuilder(15 + this.colorSpace.value.length() + this.channels.getLength() * 8);
        buf.append("color(").append(this.colorSpace.getCssText());
        Iterator<NumericValue> iterator = this.channels.iterator();
        while (iterator.hasNext()) {
            NumericValue ch = iterator.next();
            buf.append(' ').append(ch.getCssText());
        }
        if (!this.isOpaque()) {
            buf.append(" / ").append(this.getAlpha().getCssText());
        }
        buf.append(')');
        return buf.toString();
    }

    private NumericValue numericComponent(NumericValue ch) throws DOMSyntaxException {
        if (ch.getUnitType() != 2 && ch.getUnitType() != 0) {
            throw new DOMSyntaxException("color() component must be a number or percentage.");
        }
        this.componentize(ch);
        return ch;
    }

    @Override
    public ColorFunction clone() {
        ColorFunction clon;
        try {
            clon = new ColorFunction(this.getColorSpace().getValue(), this.channels);
        }
        catch (DOMSyntaxException e) {
            clon = null;
        }
        return clon;
    }

    static {
        predefinedSpaces.add("srgb");
        predefinedSpaces.add("srgb-linear");
        predefinedSpaces.add("a98-rgb");
        predefinedSpaces.add("display-p3");
        predefinedSpaces.add("prophoto-rgb");
        predefinedSpaces.add("rec2020");
        predefinedSpaces.add("xyz");
        predefinedSpaces.add("xyz-d50");
        predefinedSpaces.add("xyz-d65");
    }
}

