/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSRatioValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Objects;
import org.w3c.dom.DOMException;

public class RatioValue
extends TypedValue
implements CSSRatioValue {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue antecedentValue;
    private PrimitiveValue consequentValue;

    public RatioValue() {
        super(CSSValue.Type.RATIO);
    }

    protected RatioValue(RatioValue copied) {
        super(copied);
        this.antecedentValue = copied.antecedentValue.clone();
        this.consequentValue = copied.consequentValue.clone();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(32);
        try {
            this.writeCssText((SimpleWriter)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.antecedentValue.writeCssText(wri);
        wri.write('/');
        this.consequentValue.writeCssText(wri);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory vf = new ValueFactory();
        PrimitiveValue value = vf.parseMediaFeature(cssText);
        if (value.getPrimitiveType() != CSSValue.Type.RATIO) {
            throw new DOMException(13, "Value is not a ratio.");
        }
        RatioValue ratio = (RatioValue)value;
        this.antecedentValue = ratio.antecedentValue;
        this.consequentValue = ratio.consequentValue;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public PrimitiveValue getAntecedentValue() {
        return this.antecedentValue;
    }

    @Override
    public PrimitiveValue getConsequentValue() {
        return this.consequentValue;
    }

    public void setAntecedentValue(PrimitiveValue antecedentValue) throws DOMException {
        this.checkValueType(antecedentValue);
        this.antecedentValue = antecedentValue;
    }

    public void setConsequentValue(PrimitiveValue consequentValue) throws DOMException {
        this.checkValueType(consequentValue);
        this.consequentValue = consequentValue;
    }

    private void checkValueType(PrimitiveValue value) throws DOMException {
        if (value == null) {
            throw new DOMException(5, "Null value in ratio.");
        }
        CSSValue.CssType cat = value.getCssValueType();
        CSSValue.Type ptype = value.getPrimitiveType();
        if (cat != CSSValue.CssType.PROXY && (cat != CSSValue.CssType.TYPED || (ptype != CSSValue.Type.NUMERIC || RatioValue.isNotPositiveNumber(value)) && ptype != CSSValue.Type.EXPRESSION)) {
            throw new DOMException(12, "Unexpected type in ratio: " + (Object)((Object)ptype));
        }
    }

    private static boolean isNotPositiveNumber(PrimitiveValue value) {
        if (value.getUnitType() != 0) {
            throw new DOMException(15, "Ratio components cannot have dimensions.");
        }
        if (!value.isNegativeNumber()) {
            return false;
        }
        throw new DOMException(15, "Ratio components cannot be negative.");
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        switch (index) {
            case 0: {
                return this.antecedentValue;
            }
            case 1: {
                return this.consequentValue;
            }
        }
        return null;
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        if (component == null) {
            throw new NullPointerException();
        }
        PrimitiveValue primi = (PrimitiveValue)component;
        switch (index) {
            case 0: {
                this.antecedentValue = primi;
                break;
            }
            case 1: {
                this.consequentValue = primi;
            }
        }
    }

    @Override
    public int getComponentCount() {
        return 2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.antecedentValue, this.consequentValue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RatioValue other = (RatioValue)obj;
        return Objects.equals(this.antecedentValue, other.antecedentValue) && Objects.equals(this.consequentValue, other.consequentValue);
    }

    @Override
    public RatioValue clone() {
        return new RatioValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit nextUnit) {
            this.nextLexicalUnit = nextUnit;
        }
    }
}

