/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.LinkedNodeList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class DOMNamedNodeMap<T extends AbstractDOMNode>
implements NamedNodeMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    private final short nodeType;
    private final HashMap<String, T> attributeMap;
    private final AbstractDOMNode.RawNodeList attributes;

    DOMNamedNodeMap(short nodeType) {
        this.nodeType = nodeType;
        this.attributeMap = new HashMap();
        this.attributes = new MyLinkedNodeList();
    }

    AbstractDOMNode.RawNodeList getNodeList() {
        return this.attributes;
    }

    public T getNamedItem(String name) {
        AbstractDOMNode ret = (AbstractDOMNode)this.attributeMap.get(name);
        if (ret == null && name != null && name.indexOf(58) == -1 && this.isCaseInsensitive()) {
            name = name.toLowerCase(Locale.ROOT);
            ret = (AbstractDOMNode)this.attributeMap.get(name);
        }
        return (T)ret;
    }

    private boolean isCaseInsensitive() {
        String docNsUri;
        DOMDocument doc = (DOMDocument)this.getOwnerNode().getOwnerDocument();
        return doc.isHTML() || (docNsUri = doc.getNamespaceURI()) == "http://www.w3.org/1999/xhtml" || docNsUri == SVG_NAMESPACE_URI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T setNamedItem(Node arg) throws DOMException {
        this.verifyNewNode(arg);
        AbstractDOMNode node = (AbstractDOMNode)arg;
        String name = this.getMapKeyName(node);
        AbstractDOMNode oldNode = (AbstractDOMNode)this.attributeMap.get(name);
        if (oldNode != null) {
            if (oldNode == arg) {
                return null;
            }
            if (!this.isSameNamespace(node.getNamespaceURI(), oldNode) && node.getNamespaceURI() != null) throw new DOMException(14, "Bad prefix in " + arg.getNodeName());
            this.attributes.replace(node, oldNode);
        } else {
            this.attributes.add(node);
        }
        AbstractDOMNode oldItem = this.attributeMap.put(name, node);
        this.registerNode(node);
        return (T)oldItem;
    }

    void setNamedItemUnchecked(Node arg) {
        AbstractDOMNode node = (AbstractDOMNode)arg;
        String name = this.getMapKeyName(node);
        this.attributes.add(node);
        this.attributeMap.put(name, node);
        this.registerNode(node);
    }

    private String getMapKeyName(Node node) {
        return node.getNodeName();
    }

    void registerNode(T arg) {
    }

    void verifyNewNode(Node arg) throws DOMException {
        if (this.getOwnerNode().getOwnerDocument() != arg.getOwnerDocument()) {
            throw new DOMException(4, "Node was created by different document.");
        }
    }

    public T removeNamedItem(String name) throws DOMException {
        if (!this.attributeMap.containsKey(name)) {
            if (name != null && name.indexOf(58) == -1 && this.isCaseInsensitive()) {
                name = name.toLowerCase(Locale.ROOT);
            }
            if (!this.attributeMap.containsKey(name)) {
                throw new DOMException(8, "No attribute with that name: " + name);
            }
        }
        AbstractDOMNode removedItem = (AbstractDOMNode)this.attributeMap.remove(name);
        this.unregisterNode(removedItem);
        this.attributes.remove(removedItem);
        return (T)removedItem;
    }

    T removeItem(Node node) {
        String name = this.getMapKeyName(node);
        AbstractDOMNode retval = (AbstractDOMNode)this.attributeMap.remove(name);
        if (retval == null) {
            throw new DOMException(8, "Not an attribute from this collection.");
        }
        this.unregisterNode(retval);
        this.attributes.remove((AbstractDOMNode)node);
        return (T)retval;
    }

    void replaceItem(T newNode, T old) {
        this.verifyNewNode((Node)newNode);
        this.unregisterNode(old);
        this.attributes.replace((AbstractDOMNode)newNode, (AbstractDOMNode)old);
        String name = this.getMapKeyName((Node)old);
        this.attributeMap.remove(name);
        name = this.getMapKeyName((Node)newNode);
        this.attributeMap.put(name, newNode);
        this.registerNode(newNode);
    }

    void unregisterNode(T removedItem) {
    }

    boolean hasAttribute(String lcname) {
        return this.attributeMap.containsKey(lcname);
    }

    public T item(int index) {
        return (T)((AbstractDOMNode)this.attributes.item(index));
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public int getLength() {
        return this.attributeMap.size();
    }

    void updatePrefix(Node node, String newPrefix, String oldPrefix) {
        String name = node.getLocalName();
        if (oldPrefix != null && oldPrefix.length() != 0) {
            name = oldPrefix + ':' + name;
        }
        for (DOMNode n : this.attributes) {
            if (n != node) continue;
            this.attributeMap.remove(name);
            this.attributeMap.put(node.getNodeName(), (AbstractDOMNode)node);
        }
    }

    public T getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if ("http://www.w3.org/1999/xhtml".equals(namespaceURI) || namespaceURI == null && this.isCaseInsensitive()) {
            return this.getCINamedItem(namespaceURI, localName);
        }
        return this.getCSNamedItem(namespaceURI, localName);
    }

    private T getCINamedItem(String namespaceURI, String localName) {
        for (DOMNode node : this.attributes) {
            if (!node.getLocalName().equalsIgnoreCase(localName) || !this.isSameNamespace(namespaceURI, node)) continue;
            AbstractDOMNode node2 = (AbstractDOMNode)node;
            return (T)node2;
        }
        return null;
    }

    private T getCSNamedItem(String namespaceURI, String localName) {
        for (DOMNode node : this.attributes) {
            if (!node.getLocalName().equals(localName) || !this.isSameNamespace(namespaceURI, node)) continue;
            AbstractDOMNode node2 = (AbstractDOMNode)node;
            return (T)node2;
        }
        return null;
    }

    public T setNamedItemNS(Node arg) throws DOMException {
        return (T)this.setNamedItem(arg);
    }

    public T removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if ("http://www.w3.org/1999/xhtml".equals(namespaceURI) || namespaceURI == null && this.isCaseInsensitive()) {
            return this.removeCINamedItem(namespaceURI, localName);
        }
        return this.removeCSNamedItem(namespaceURI, localName);
    }

    private T removeCINamedItem(String namespaceURI, String localName) {
        for (DOMNode node : this.attributes) {
            if (!node.getLocalName().equalsIgnoreCase(localName) || !this.isSameNamespace(namespaceURI, node)) continue;
            this.attributes.remove((AbstractDOMNode)node);
            AbstractDOMNode retval = (AbstractDOMNode)this.attributeMap.remove(node.getNodeName());
            this.unregisterNode(retval);
            return (T)retval;
        }
        return null;
    }

    private T removeCSNamedItem(String namespaceURI, String localName) {
        for (DOMNode node : this.attributes) {
            if (!node.getLocalName().equals(localName) || !this.isSameNamespace(namespaceURI, node)) continue;
            this.attributes.remove((AbstractDOMNode)node);
            AbstractDOMNode retval = (AbstractDOMNode)this.attributeMap.remove(node.getNodeName());
            this.unregisterNode(retval);
            return (T)retval;
        }
        return null;
    }

    void insertAfter(T newNode, AbstractDOMNode refNode) {
        AbstractDOMNode next = refNode.nextSibling;
        if (next != null) {
            this.attributes.insertBefore((AbstractDOMNode)newNode, next);
        } else {
            this.attributes.add((AbstractDOMNode)newNode);
        }
        String name = this.getMapKeyName((Node)newNode);
        this.attributeMap.put(name, newNode);
        this.registerNode(newNode);
    }

    private boolean isSameNamespace(String namespaceURI, Node memberNode) {
        return Objects.equals(namespaceURI, memberNode.getNamespaceURI());
    }

    public int hashCode() {
        int prime = 31;
        int result = this.nodeType;
        TreeSet<String> sorted = new TreeSet<String>(this.attributeMap.keySet());
        for (String key : sorted) {
            result = 31 * result + key.hashCode();
            result = 31 * result + ((AbstractDOMNode)this.attributeMap.get(key)).hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMNamedNodeMap other = (DOMNamedNodeMap)obj;
        if (this.nodeType != other.nodeType) {
            return false;
        }
        if (this.attributeMap == null) {
            return other.attributeMap == null;
        }
        return this.sameNodes(other.attributeMap);
    }

    private boolean sameNodes(HashMap<String, ?> otherAttr) {
        if (this.attributeMap.size() != otherAttr.size()) {
            return false;
        }
        for (Map.Entry<String, T> me : this.attributeMap.entrySet()) {
            Node otherNode;
            String key = me.getKey();
            Node node = (Node)me.getValue();
            if (node.isEqualNode(otherNode = (Node)otherAttr.get(key))) continue;
            return false;
        }
        return true;
    }

    public void appendTo(StringBuilder buf) {
        Iterator it = this.attributes.iterator();
        if (it.hasNext()) {
            DOMNode node = (DOMNode)it.next();
            buf.append(node.toString());
            while (it.hasNext()) {
                node = (DOMNode)it.next();
                buf.append(' ').append(node.toString());
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.attributeMap.size() * 24 + 12);
        this.appendTo(buf);
        return buf.toString();
    }

    abstract Node getOwnerNode();

    private static class MyLinkedNodeList
    extends LinkedNodeList {
        private static final long serialVersionUID = 1L;

        private MyLinkedNodeList() {
        }

        @Override
        void preAddChild(Node node) {
        }

        @Override
        void postAddChild(AbstractDOMNode node) {
        }

        @Override
        void replaceChild(Node newChild, Node oldChild) {
        }

        @Override
        void postRemoveChild(AbstractDOMNode removed) {
        }
    }
}

