/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.parser.LengthHandler;
import io.sf.carte.echosvg.parser.LengthParser;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.UnitProcessor;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGLength
implements SVGLength {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected short unitType;
    protected float value;
    protected short direction;
    protected UnitProcessor.Context context = new DefaultContext();

    protected abstract SVGOMElement getAssociatedElement();

    public AbstractSVGLength(short s) {
        this.direction = s;
        this.value = 0.0f;
        this.unitType = 0;
    }

    public short getCSSUnitType() {
        this.revalidate();
        return this.unitType;
    }

    public short getUnitType() {
        return AbstractSVGLength.getSVGUnitType(this.getCSSUnitType());
    }

    private static short getSVGUnitType(short s) {
        short s2;
        switch (s) {
            case 0: {
                s2 = 1;
                break;
            }
            case 3: {
                s2 = 5;
                break;
            }
            case 20: {
                s2 = 3;
                break;
            }
            case 21: {
                s2 = 4;
                break;
            }
            case 4: {
                s2 = 8;
                break;
            }
            case 7: {
                s2 = 6;
                break;
            }
            case 8: {
                s2 = 7;
                break;
            }
            case 5: {
                s2 = 10;
                break;
            }
            case 6: {
                s2 = 9;
                break;
            }
            case 2: {
                s2 = 2;
                break;
            }
            default: {
                s2 = 0;
            }
        }
        return s2;
    }

    public float getValue() {
        this.revalidate();
        try {
            return UnitProcessor.cssToUserSpace((float)this.value, (short)this.unitType, (short)this.direction, (UnitProcessor.Context)this.context);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0.0f;
        }
    }

    public void setValue(float f) throws DOMException {
        this.value = UnitProcessor.userSpaceToCSS((float)f, (short)this.unitType, (short)this.direction, (UnitProcessor.Context)this.context);
        this.reset();
    }

    public float getValueInSpecifiedUnits() {
        this.revalidate();
        return this.value;
    }

    public void setValueInSpecifiedUnits(float f) throws DOMException {
        this.revalidate();
        this.value = f;
        this.reset();
    }

    public String getValueAsString() {
        this.revalidate();
        if (this.unitType == 255) {
            return "";
        }
        return Float.toString(this.value) + CSSUnit.dimensionUnitString((short)this.unitType);
    }

    public void setValueAsString(String string) throws DOMException {
        this.parse(string);
        this.reset();
    }

    public void newValueSpecifiedCSSUnits(short s, float f) {
        this.unitType = s;
        this.value = f;
        this.reset();
    }

    public void newValueSpecifiedUnits(short s, float f) throws DOMException {
        this.newValueSpecifiedCSSUnits(AbstractSVGLength.getCSSUnitType(s), f);
    }

    private static short getCSSUnitType(short s) throws DOMException {
        short s2;
        switch (s) {
            case 1: {
                s2 = 0;
                break;
            }
            case 5: {
                s2 = 3;
                break;
            }
            case 3: {
                s2 = 20;
                break;
            }
            case 4: {
                s2 = 21;
                break;
            }
            case 8: {
                s2 = 4;
                break;
            }
            case 6: {
                s2 = 7;
                break;
            }
            case 7: {
                s2 = 8;
                break;
            }
            case 10: {
                s2 = 5;
                break;
            }
            case 9: {
                s2 = 6;
                break;
            }
            case 2: {
                s2 = 2;
                break;
            }
            default: {
                throw new DOMException(9, "Unit not supported: " + s);
            }
        }
        return s2;
    }

    public void convertToSpecifiedUnits(short s) throws DOMException {
        float f = this.getValue();
        f = NumberValue.floatValueConversion((float)f, (short)this.unitType, (short)AbstractSVGLength.getCSSUnitType(s));
        this.unitType = s;
        this.setValue(f);
    }

    protected void reset() {
    }

    protected void revalidate() {
    }

    protected void parse(String string) {
        try {
            UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver(){

                protected float unitToPixels(short s, float f, short s2) {
                    return UnitProcessor.cssToUserSpace((float)f, (short)s, (short)AbstractSVGLength.this.direction, (UnitProcessor.Context)AbstractSVGLength.this.context);
                }
            };
            LengthParser lengthParser = new LengthParser((LengthHandler)unitResolver);
            lengthParser.parse(string);
            this.unitType = unitResolver.unit;
            this.value = unitResolver.value;
        }
        catch (ParseException parseException) {
            this.unitType = (short)255;
            this.value = 0.0f;
        }
    }

    protected class DefaultContext
    implements UnitProcessor.Context {
        protected DefaultContext() {
        }

        public Element getElement() {
            return AbstractSVGLength.this.getAssociatedElement();
        }

        public float getResolution() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getResolution();
        }

        public float getFontSize() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getFontSize();
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getLineHeight() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getLineHeight();
        }

        public float getRootFontSize() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getRootFontSize();
        }

        public float getRootXHeight() {
            return 0.5f;
        }

        public float getRootLineHeight() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getRootLineHeight();
        }

        public float getViewportWidth() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getViewportWidth();
        }

        public float getViewportHeight() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getViewportHeight();
        }
    }
}

