/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SMDTDLoader
extends DefaultEntityResolver.DTDLoader {
    @Override
    void connect(final URLConnection uRLConnection) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    uRLConnection.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    @Override
    Reader loadDTDfromClasspath(final ClassLoader classLoader, final String string) {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                InputStream inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : DefaultEntityResolver.class.getResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = ClassLoader.getSystemResourceAsStream(string);
                }
                return inputStream;
            }
        });
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        }
        return inputStreamReader;
    }
}

