/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.SVGOMAElement;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimationElement;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.CursorManager;
import io.sf.carte.echosvg.bridge.SVGGElementBridge;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.dom.events.AbstractEvent;
import io.sf.carte.echosvg.dom.events.NodeEventTarget;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Cursor;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends SVGGElementBridge {
    protected AnchorListener al;
    protected CursorMouseOverListener bl;
    protected CursorMouseOutListener cl;

    @Override
    public String getLocalName() {
        return "a";
    }

    @Override
    public Bridge getInstance() {
        return new SVGAElementBridge();
    }

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            NodeEventTarget nodeEventTarget = (NodeEventTarget)element;
            CursorHolder cursorHolder = new CursorHolder(CursorManager.DEFAULT_CURSOR);
            this.al = new AnchorListener(bridgeContext.getUserAgent(), cursorHolder);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", (EventListener)this.al, false, null);
            bridgeContext.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "click", this.al, false);
            this.bl = new CursorMouseOverListener(bridgeContext.getUserAgent(), cursorHolder);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)this.bl, false, null);
            bridgeContext.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseover", this.bl, false);
            this.cl = new CursorMouseOutListener(bridgeContext.getUserAgent(), cursorHolder);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", (EventListener)this.cl, false, null);
            bridgeContext.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseout", this.cl, false);
        }
    }

    @Override
    public void dispose() {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)this.e;
        if (this.al != null) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", (EventListener)this.al, false);
            this.al = null;
        }
        if (this.bl != null) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)this.bl, false);
            this.bl = null;
        }
        if (this.cl != null) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", (EventListener)this.cl, false);
            this.cl = null;
        }
        super.dispose();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public static class AnchorDefaultActionable
    implements Runnable {
        protected SVGOMAElement elt;
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public AnchorDefaultActionable(SVGAElement sVGAElement, UserAgent userAgent, CursorHolder cursorHolder) {
            this.elt = (SVGOMAElement)sVGAElement;
            this.userAgent = userAgent;
            this.holder = cursorHolder;
        }

        @Override
        public void run() {
            Element element;
            String string;
            this.userAgent.setSVGCursor(this.holder.getCursor());
            String string2 = this.elt.getHref().getAnimVal();
            ParsedURL parsedURL = new ParsedURL(this.elt.getBaseURI(), string2);
            SVGOMDocument sVGOMDocument = (SVGOMDocument)this.elt.getOwnerDocument();
            ParsedURL parsedURL2 = sVGOMDocument.getParsedURL();
            if (parsedURL.sameFile(parsedURL2) && (string = parsedURL.getRef()) != null && string.length() != 0 && (element = sVGOMDocument.getElementById(string)) instanceof SVGOMAnimationElement) {
                SVGOMAnimationElement sVGOMAnimationElement = (SVGOMAnimationElement)element;
                float f = sVGOMAnimationElement.getHyperlinkBeginTime();
                if (Float.isNaN(f)) {
                    sVGOMAnimationElement.beginElement();
                } else {
                    sVGOMDocument.getRootElement().setCurrentTime(f);
                }
                return;
            }
            this.userAgent.openLink((SVGAElement)this.elt);
        }
    }

    public static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public AnchorListener(UserAgent userAgent, CursorHolder cursorHolder) {
            this.userAgent = userAgent;
            this.holder = cursorHolder;
        }

        @Override
        public void handleEvent(Event event) {
            if (!(event instanceof AbstractEvent)) {
                return;
            }
            AbstractEvent abstractEvent = (AbstractEvent)event;
            List list = abstractEvent.getDefaultActions();
            if (list != null) {
                for (Runnable runnable : list) {
                    if (!(runnable instanceof AnchorDefaultActionable)) continue;
                    return;
                }
            }
            SVGAElement sVGAElement = (SVGAElement)event.getCurrentTarget();
            abstractEvent.addDefaultAction((Runnable)new AnchorDefaultActionable(sVGAElement, this.userAgent, this.holder));
        }
    }

    public static class CursorHolder {
        Cursor cursor = null;

        public CursorHolder(Cursor cursor) {
            this.cursor = cursor;
        }

        public void holdCursor(Cursor cursor) {
            this.cursor = cursor;
        }

        public Cursor getCursor() {
            return this.cursor;
        }
    }

    public static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public CursorMouseOutListener(UserAgent userAgent, CursorHolder cursorHolder) {
            this.userAgent = userAgent;
            this.holder = cursorHolder;
        }

        @Override
        public void handleEvent(Event event) {
            if (!(event instanceof AbstractEvent)) {
                return;
            }
            AbstractEvent abstractEvent = (AbstractEvent)event;
            List list = abstractEvent.getDefaultActions();
            if (list != null) {
                for (Runnable runnable : list) {
                    if (!(runnable instanceof MouseOutDefaultActionable)) continue;
                    return;
                }
            }
            SVGAElement sVGAElement = (SVGAElement)event.getCurrentTarget();
            abstractEvent.addDefaultAction((Runnable)new MouseOutDefaultActionable(sVGAElement, this.userAgent, this.holder));
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public CursorMouseOverListener(UserAgent userAgent, CursorHolder cursorHolder) {
            this.userAgent = userAgent;
            this.holder = cursorHolder;
        }

        @Override
        public void handleEvent(Event event) {
            Object object2;
            if (!(event instanceof AbstractEvent)) {
                return;
            }
            AbstractEvent abstractEvent = (AbstractEvent)event;
            List list = abstractEvent.getDefaultActions();
            if (list != null) {
                for (Object object2 : list) {
                    if (!(object2 instanceof MouseOverDefaultActionable)) continue;
                    return;
                }
            }
            Element element = (Element)((Object)abstractEvent.getTarget());
            object2 = (SVGAElement)abstractEvent.getCurrentTarget();
            abstractEvent.addDefaultAction((Runnable)new MouseOverDefaultActionable(element, (SVGAElement)object2, this.userAgent, this.holder));
        }
    }

    public static class MouseOutDefaultActionable
    implements Runnable {
        protected SVGAElement elt;
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public MouseOutDefaultActionable(SVGAElement sVGAElement, UserAgent userAgent, CursorHolder cursorHolder) {
            this.elt = sVGAElement;
            this.userAgent = userAgent;
            this.holder = cursorHolder;
        }

        @Override
        public void run() {
            if (this.elt != null) {
                this.userAgent.displayMessage("");
            }
        }
    }

    public static class MouseOverDefaultActionable
    implements Runnable {
        protected Element target;
        protected SVGAElement elt;
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public MouseOverDefaultActionable(Element element, SVGAElement sVGAElement, UserAgent userAgent, CursorHolder cursorHolder) {
            this.target = element;
            this.elt = sVGAElement;
            this.userAgent = userAgent;
            this.holder = cursorHolder;
        }

        @Override
        public void run() {
            if (CSSUtilities.isAutoCursor(this.target)) {
                this.holder.holdCursor(CursorManager.DEFAULT_CURSOR);
                this.userAgent.setSVGCursor(CursorManager.ANCHOR_CURSOR);
            }
            if (this.elt != null) {
                String string = this.elt.getHref().getAnimVal();
                this.userAgent.displayMessage(string);
            }
        }
    }
}

