/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.Hashtable;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeCollectionIterator
extends ES6Iterator {
    private static final long serialVersionUID = 7094840979404373443L;
    private String className;
    private Type type;
    private transient Iterator<Hashtable.Entry> iterator = Collections.emptyIterator();

    static void init(ScriptableObject scriptableObject, String string, boolean bl) {
        ES6Iterator.init(scriptableObject, bl, new NativeCollectionIterator(string), string);
    }

    public NativeCollectionIterator(String string) {
        this.className = string;
        this.iterator = Collections.emptyIterator();
        this.type = Type.BOTH;
    }

    public NativeCollectionIterator(Scriptable scriptable, String string, Type type, Iterator<Hashtable.Entry> iterator) {
        super(scriptable, string);
        this.className = string;
        this.iterator = iterator;
        this.type = type;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected boolean isDone(Context context, Scriptable scriptable) {
        return !this.iterator.hasNext();
    }

    @Override
    protected Object nextValue(Context context, Scriptable scriptable) {
        Hashtable.Entry entry = this.iterator.next();
        switch (this.type) {
            case KEYS: {
                return entry.key;
            }
            case VALUES: {
                return entry.value;
            }
            case BOTH: {
                return context.newArray(scriptable, new Object[]{entry.key, entry.value});
            }
        }
        throw new AssertionError();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.className = (String)objectInputStream.readObject();
        this.type = (Type)((Object)objectInputStream.readObject());
        this.iterator = Collections.emptyIterator();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.className);
        objectOutputStream.writeObject((Object)this.type);
    }

    static enum Type {
        KEYS,
        VALUES,
        BOTH;

    }
}

